/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.core.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Page<T> {
    public static final String ASC = "asc";
    public static final String DESC = "desc";
    protected int pageNo = 1;
    protected int pageSize = 1;
    protected String orderBy = null;
    protected String order = null;
    protected boolean autoCount = true;
    protected List<T> result = new ArrayList<T>();
    protected long totalCount = -1L;

    public Page() {
    }

    public Page(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
        if (pageNo < 1) {
            this.pageNo = 1;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        if (pageSize < 1) {
            this.pageSize = 1;
        }
    }

    public int getFirst() {
        return (this.pageNo - 1) * this.pageSize + 1;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        String[] orders;
        String[] stringArray = orders = StringUtils.split((String)StringUtils.lowerCase((String)order), (char)',');
        int n = orders.length;
        int n2 = 0;
        while (n2 < n) {
            String orderStr = stringArray[n2];
            if (!StringUtils.equals((CharSequence)DESC, (CharSequence)orderStr) && !StringUtils.equals((CharSequence)ASC, (CharSequence)orderStr)) {
                throw new IllegalArgumentException("\u6392\u5e8f\u65b9\u5411" + orderStr + "\u4e0d\u662f\u5408\u6cd5\u503c");
            }
            ++n2;
        }
        this.order = StringUtils.lowerCase((String)order);
    }

    public Page<T> order(String theOrder) {
        this.setOrder(theOrder);
        return this;
    }

    public boolean isOrderBySetted() {
        return StringUtils.isNotBlank((CharSequence)this.orderBy) && StringUtils.isNotBlank((CharSequence)this.order);
    }

    public boolean isAutoCount() {
        return this.autoCount;
    }

    public void setAutoCount(boolean autoCount) {
        this.autoCount = autoCount;
    }

    public List<T> getResult() {
        return this.result;
    }

    public void setResult(List<T> result) {
        this.result = result;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    public long getTotalPages() {
        if (this.totalCount < 0L) {
            return -1L;
        }
        long count = this.totalCount / (long)this.pageSize;
        if (this.totalCount % (long)this.pageSize > 0L) {
            ++count;
        }
        return count;
    }

    public boolean isHasNext() {
        return (long)(this.pageNo + 1) <= this.getTotalPages();
    }

    public int getNextPage() {
        if (this.isHasNext()) {
            return this.pageNo + 1;
        }
        return this.pageNo;
    }

    public boolean isHasPre() {
        return this.pageNo - 1 >= 1;
    }

    public int getPrePage() {
        if (this.isHasPre()) {
            return this.pageNo - 1;
        }
        return this.pageNo;
    }
}

