/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.core.dao.support;

import com.zainta.core.utils.ReflectionUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.metadata.ClassMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class SimpleHibernateDao<T, PK extends Serializable> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected SessionFactory sessionFactory;
    protected Class<T> entityClass;

    public SimpleHibernateDao() {
        this.entityClass = ReflectionUtils.getSuperClassGenricType(this.getClass());
    }

    public SimpleHibernateDao(SessionFactory sessionFactory, Class<T> entityClass) {
        this.sessionFactory = sessionFactory;
        this.entityClass = entityClass;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public void save(T entity) {
        Assert.notNull(entity, (String)"entity\u4e0d\u80fd\u4e3a\u7a7a");
        this.getSession().saveOrUpdate(entity);
        this.logger.debug("save entity: {}", entity);
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"entity\u4e0d\u80fd\u4e3a\u7a7a");
        this.getSession().delete(entity);
        this.logger.debug("delete entity: {}", entity);
    }

    public void delete(PK id) {
        Assert.notNull(id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.delete((PK)this.load(id));
        this.logger.debug("delete entity {},id is {}", (Object)this.entityClass.getSimpleName(), id);
    }

    public T load(PK id) {
        Assert.notNull(id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return (T)this.getSession().load(this.entityClass, id);
    }

    public T get(PK id) {
        Assert.notNull(id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return (T)this.getSession().get(this.entityClass, id);
    }

    public List<T> getAll() {
        return this.find(new Criterion[0]);
    }

    public List<T> getAll(String orderBy, boolean isAsc) {
        Criteria c = this.createCriteria(new Criterion[0]);
        if (isAsc) {
            c.addOrder(Order.asc((String)orderBy));
        } else {
            c.addOrder(Order.desc((String)orderBy));
        }
        return c.list();
    }

    public List<T> findBy(String propertyName, Object value) {
        Assert.hasText((String)propertyName, (String)"propertyName\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleExpression criterion = Restrictions.eq((String)propertyName, (Object)value);
        return this.find(new Criterion[]{criterion});
    }

    public T findUniqueBy(String propertyName, Object value) {
        Assert.hasText((String)propertyName, (String)"propertyName\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleExpression criterion = Restrictions.eq((String)propertyName, (Object)value);
        return (T)this.createCriteria(new Criterion[]{criterion}).uniqueResult();
    }

    public List<T> findByIds(List<PK> ids) {
        return this.find(Restrictions.in((String)this.getIdName(), ids));
    }

    public <X> List<X> find(String hql, Object ... values) {
        return this.createQuery(hql, values).list();
    }

    public <X> List<X> find(String hql, Map<String, ?> values) {
        return this.createQuery(hql, values).list();
    }

    public <X> X findUnique(String hql, Object ... values) {
        return (X)this.createQuery(hql, values).uniqueResult();
    }

    public <X> X findUnique(String hql, Map<String, ?> values) {
        return (X)this.createQuery(hql, values).uniqueResult();
    }

    public int batchExecute(String hql, Object ... values) {
        return this.createQuery(hql, values).executeUpdate();
    }

    public int batchExecute(String hql, Map<String, ?> values) {
        return this.createQuery(hql, values).executeUpdate();
    }

    public Query createQuery(String queryString, Object ... values) {
        Assert.hasText((String)queryString, (String)"queryString\u4e0d\u80fd\u4e3a\u7a7a");
        Query query = this.getSession().createQuery(queryString);
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                query.setParameter(i, values[i]);
                ++i;
            }
        }
        return query;
    }

    public Query createQuery(String queryString, Map<String, ?> values) {
        Assert.hasText((String)queryString, (String)"queryString\u4e0d\u80fd\u4e3a\u7a7a");
        Query query = this.getSession().createQuery(queryString);
        if (values != null) {
            query.setProperties(values);
        }
        return query;
    }

    public List<T> find(Criterion ... criterions) {
        return this.createCriteria(criterions).list();
    }

    public T findUnique(Criterion ... criterions) {
        return (T)this.createCriteria(criterions).uniqueResult();
    }

    public Criteria createCriteria(Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(this.entityClass);
        Criterion[] criterionArray = criterions;
        int n = criterions.length;
        int n2 = 0;
        while (n2 < n) {
            Criterion c = criterionArray[n2];
            criteria.add(c);
            ++n2;
        }
        return criteria;
    }

    public void initEntity(T entity) {
        Hibernate.initialize(entity);
    }

    public void initEntity(List<T> entityList) {
        for (T entity : entityList) {
            Hibernate.initialize(entity);
        }
    }

    public void flush() {
        this.getSession().flush();
    }

    public Query distinct(Query query) {
        query.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return query;
    }

    public Criteria distinct(Criteria criteria) {
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria;
    }

    public String getIdName() {
        ClassMetadata meta = this.getSessionFactory().getClassMetadata(this.entityClass);
        return meta.getIdentifierPropertyName();
    }
}

