/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.core.dao.support;

import com.zainta.core.dao.support.SimpleHibernateDao;
import com.zainta.core.model.Page;
import com.zainta.core.model.PropertyFilter;
import com.zainta.core.utils.ReflectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.transform.ResultTransformer;
import org.springframework.util.Assert;

public class HibernateDao<T, PK extends Serializable>
extends SimpleHibernateDao<T, PK> {
    public HibernateDao() {
    }

    public HibernateDao(SessionFactory sessionFactory, Class<T> entityClass) {
        super(sessionFactory, entityClass);
    }

    public Page<T> getAll(Page<T> page) {
        return this.findPage(page, new Criterion[0]);
    }

    public Page<T> findPage(Page<T> page, String hql, Object ... values) {
        Assert.notNull(page, (String)"page\u4e0d\u80fd\u4e3a\u7a7a");
        Query q = this.createQuery(hql, values);
        if (page.isAutoCount()) {
            long totalCount = this.countHqlResult(hql, values);
            page.setTotalCount(totalCount);
        }
        this.setPageParameter(q, page);
        List result = q.list();
        page.setResult(result);
        return page;
    }

    public Page<T> findPage(Page<T> page, String hql, Map<String, ?> values) {
        Assert.notNull(page, (String)"page\u4e0d\u80fd\u4e3a\u7a7a");
        Query q = this.createQuery(hql, values);
        if (page.isAutoCount()) {
            long totalCount = this.countHqlResult(hql, values);
            page.setTotalCount(totalCount);
        }
        this.setPageParameter(q, page);
        List result = q.list();
        page.setResult(result);
        return page;
    }

    public Page<T> findPage(Page<T> page, Criterion ... criterions) {
        Assert.notNull(page, (String)"page\u4e0d\u80fd\u4e3a\u7a7a");
        Criteria c = this.createCriteria(criterions);
        if (page.isAutoCount()) {
            int totalCount = this.countCriteriaResult(c);
            page.setTotalCount(totalCount);
        }
        this.setPageParameter(c, page);
        List result = c.list();
        page.setResult(result);
        return page;
    }

    protected Query setPageParameter(Query q, Page<T> page) {
        q.setFirstResult(page.getFirst() - 1);
        q.setMaxResults(page.getPageSize());
        return q;
    }

    protected Criteria setPageParameter(Criteria c, Page<T> page) {
        c.setFirstResult(page.getFirst() - 1);
        c.setMaxResults(page.getPageSize());
        if (page.isOrderBySetted()) {
            String[] orderArray;
            String[] orderByArray = StringUtils.split((String)page.getOrderBy(), (char)',');
            Assert.isTrue((orderByArray.length == (orderArray = StringUtils.split((String)page.getOrder(), (char)',')).length ? 1 : 0) != 0, (String)"\u5206\u9875\u591a\u91cd\u6392\u5e8f\u53c2\u6570\u4e2d,\u6392\u5e8f\u5b57\u6bb5\u4e0e\u6392\u5e8f\u65b9\u5411\u7684\u4e2a\u6570\u4e0d\u76f8\u7b49");
            int i = 0;
            while (i < orderByArray.length) {
                if ("asc".equals(orderArray[i])) {
                    c.addOrder(Order.asc((String)orderByArray[i]));
                } else {
                    c.addOrder(Order.desc((String)orderByArray[i]));
                }
                ++i;
            }
        }
        return c;
    }

    protected long countHqlResult(String hql, Object ... values) {
        String fromHql = hql;
        fromHql = hql.contains("from") ? "from " + StringUtils.substringAfter((String)fromHql, (String)"from") : "From " + StringUtils.substringAfter((String)fromHql, (String)"From");
        fromHql = StringUtils.substringBefore((String)fromHql, (String)"order by");
        String countHql = "select count(*) " + fromHql;
        try {
            Long count = (Long)this.findUnique(countHql.replaceAll("fetch", ""), values);
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException("hql can't be auto count, hql is:" + countHql, e);
        }
    }

    protected long countHqlResult(String hql, Map<String, ?> values) {
        String fromHql = hql;
        fromHql = "from " + StringUtils.substringAfter((String)fromHql, (String)"from");
        fromHql = StringUtils.substringBefore((String)fromHql, (String)"order by");
        String countHql = "select count(*) " + fromHql;
        try {
            Long count = (Long)this.findUnique(countHql.replaceAll("fetch", ""), values);
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException("hql can't be auto count, hql is:" + countHql, e);
        }
    }

    protected int countCriteriaResult(Criteria c) {
        CriteriaImpl impl = (CriteriaImpl)c;
        Projection projection = impl.getProjection();
        ResultTransformer transformer = impl.getResultTransformer();
        List orderEntries = null;
        try {
            orderEntries = (List)ReflectionUtils.getFieldValue(impl, "orderEntries");
            ReflectionUtils.setFieldValue(impl, "orderEntries", new ArrayList());
        }
        catch (Exception e) {
            this.logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        Number totalCount = (Number)c.setProjection((Projection)Projections.countDistinct((String)this.getIdName())).uniqueResult();
        c.setProjection(projection);
        if (projection == null) {
            c.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        if (transformer != null) {
            c.setResultTransformer(transformer);
        }
        try {
            ReflectionUtils.setFieldValue(impl, "orderEntries", orderEntries);
        }
        catch (Exception e) {
            this.logger.error("\u4e0d\u53ef\u80fd\u629b\u51fa\u7684\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return totalCount.intValue();
    }

    public List<T> findBy(String propertyName, Object value, PropertyFilter.MatchType matchType) {
        Criterion criterion = this.buildPropertyFilterCriterion(propertyName, value, matchType);
        return this.find(criterion);
    }

    public List<T> find(List<PropertyFilter> filters) {
        Criteria c = this.buildCriteriaByPropertyFilters(filters);
        List<T> result = this.getQueryResultByCriteria(c);
        return result;
    }

    public Page<T> findPage(Page<T> page, List<PropertyFilter> filters) {
        Assert.notNull(page, (String)"page\u4e0d\u80fd\u4e3a\u7a7a");
        Criteria c = this.buildCriteriaByPropertyFilters(filters);
        if (page.isAutoCount()) {
            int totalCount = this.countCriteriaResult(c);
            page.setTotalCount(totalCount);
        }
        this.setPageParameter(c, page);
        List<T> result = this.getQueryResultByCriteria(c);
        page.setResult(result);
        return page;
    }

    private List<T> getQueryResultByCriteria(Criteria c) {
        List idList = c.list();
        ArrayList result = new ArrayList();
        for (Serializable id : idList) {
            result.add(this.get(id));
        }
        return result;
    }

    private Criteria buildCriteriaByPropertyFilters(List<PropertyFilter> filters) {
        Criterion[] criterions = this.buildPropertyFilterCriterions(this.getAssociationPropertyFilters(filters));
        Criteria c = this.createCriteria(criterions);
        c = this.getAssociationCriteria(c, filters);
        c.setProjection(Projections.distinct((Projection)Projections.id()));
        return c;
    }

    protected Criterion[] buildPropertyFilterCriterions(List<PropertyFilter> filters) {
        ArrayList<Object> criterionList = new ArrayList<Object>();
        for (PropertyFilter filter : filters) {
            if (!filter.isMultiProperty()) {
                Criterion criterion = this.buildPropertyFilterCriterion(filter.getPropertyName(), filter.getPropertyType().getSimpleName().equals("String") ? filter.getPropertyValue().toString().trim() : filter.getPropertyValue(), filter.getMatchType());
                criterionList.add(criterion);
                continue;
            }
            Disjunction disjunction = Restrictions.disjunction();
            String[] stringArray = filter.getPropertyNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                Criterion criterion = this.buildPropertyFilterCriterion(param, filter.getPropertyType().getSimpleName().equals("String") ? filter.getPropertyValue().toString().trim() : filter.getPropertyValue(), filter.getMatchType());
                disjunction.add(criterion);
                ++n2;
            }
            criterionList.add(disjunction);
        }
        return criterionList.toArray(new Criterion[criterionList.size()]);
    }

    protected Criterion buildPropertyFilterCriterion(String propertyName, Object propertyValue, PropertyFilter.MatchType matchType) {
        Assert.hasText((String)propertyName, (String)"propertyName\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleExpression criterion = null;
        try {
            if (PropertyFilter.MatchType.EQ.equals((Object)matchType)) {
                criterion = Restrictions.eq((String)propertyName, (Object)propertyValue);
            } else if (PropertyFilter.MatchType.LIKE.equals((Object)matchType)) {
                criterion = Restrictions.like((String)propertyName, (String)((String)propertyValue), (MatchMode)MatchMode.ANYWHERE);
            } else if (PropertyFilter.MatchType.LE.equals((Object)matchType)) {
                criterion = Restrictions.le((String)propertyName, (Object)propertyValue);
            } else if (PropertyFilter.MatchType.LT.equals((Object)matchType)) {
                criterion = Restrictions.lt((String)propertyName, (Object)propertyValue);
            } else if (PropertyFilter.MatchType.GE.equals((Object)matchType)) {
                criterion = Restrictions.ge((String)propertyName, (Object)propertyValue);
            } else if (PropertyFilter.MatchType.GT.equals((Object)matchType)) {
                criterion = Restrictions.gt((String)propertyName, (Object)propertyValue);
            } else if (PropertyFilter.MatchType.NE.equals((Object)matchType)) {
                criterion = Restrictions.ne((String)propertyName, (Object)propertyValue);
            } else if (PropertyFilter.MatchType.NL.equals((Object)matchType)) {
                criterion = Restrictions.isNull((String)propertyName);
            } else if (PropertyFilter.MatchType.NNL.equals((Object)matchType)) {
                criterion = Restrictions.isNotNull((String)propertyName);
            } else if (PropertyFilter.MatchType.IN.equals((Object)matchType)) {
                criterion = Restrictions.in((String)propertyName, (Object[])((Object[])propertyValue));
            }
        }
        catch (Exception e) {
            throw ReflectionUtils.convertReflectionExceptionToUnchecked(e);
        }
        return criterion;
    }

    public boolean isPropertyUnique(String propertyName, Object newValue, Object oldValue) {
        if (newValue == null || newValue.equals(oldValue)) {
            return true;
        }
        Object object = this.findUniqueBy(propertyName, newValue);
        return object == null;
    }

    protected Criteria getAssociationCriteria(Criteria criteria, List<PropertyFilter> filters) {
        for (PropertyFilter filter : filters) {
            if (!filter.isMultiProperty()) {
                criteria = this.createAliasByFilterName(filter.getPropertyName(), criteria);
                continue;
            }
            String[] stringArray = filter.getPropertyNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String propertyName = stringArray[n2];
                criteria = this.createAliasByFilterName(propertyName, criteria);
                ++n2;
            }
        }
        return criteria;
    }

    protected Criteria createAliasByFilterName(String propertyName, Criteria criteria) {
        if (propertyName.contains(".")) {
            String nameString = StringUtils.substringBeforeLast((String)propertyName, (String)".");
            String[] names = nameString.split("\\.");
            int i = 0;
            while (i < names.length) {
                if (i == 0) {
                    if (!this.isAliasExisted(criteria, names[i])) {
                        criteria = criteria.createAlias(names[i], names[i], 1);
                    }
                } else if (!this.isAliasExisted(criteria, String.valueOf(names[i - 1]) + "." + names[i])) {
                    criteria = criteria.createAlias(String.valueOf(names[i - 1]) + "." + names[i], names[i], 1);
                }
                ++i;
            }
        }
        return criteria;
    }

    protected boolean isAliasExisted(Criteria criteria, String associationPath) {
        CriteriaImpl criterialImpl = (CriteriaImpl)criteria;
        Iterator it = criterialImpl.iterateSubcriteria();
        while (it.hasNext()) {
            CriteriaImpl.Subcriteria sub = (CriteriaImpl.Subcriteria)it.next();
            if (!sub.getPath().equals(associationPath)) continue;
            return true;
        }
        return false;
    }

    protected List<PropertyFilter> getAssociationPropertyFilters(List<PropertyFilter> filters) {
        ArrayList<PropertyFilter> listFilter = new ArrayList<PropertyFilter>();
        for (PropertyFilter filter : filters) {
            String[] propertyNames = filter.getPropertyNames();
            String[] associationPropertyNames = new String[propertyNames.length];
            int i = 0;
            while (i < propertyNames.length) {
                String associationPropertyName;
                associationPropertyNames[i] = associationPropertyName = this.getAssociationPropertyName(propertyNames[i]);
                ++i;
            }
            PropertyFilter ft = new PropertyFilter(filter.getMatchType(), filter.getPropertyType(), associationPropertyNames, filter.getPropertyValue());
            listFilter.add(ft);
        }
        return listFilter;
    }

    protected String getAssociationPropertyName(String propertyName) {
        String temp = null;
        if (!propertyName.contains(".")) {
            temp = this.unescapePropertyName(propertyName);
        } else {
            String str1 = this.unescapePropertyName(StringUtils.substringAfterLast((String)propertyName, (String)"."));
            String str2 = StringUtils.substringBeforeLast((String)propertyName, (String)".");
            if (str2.contains(".")) {
                str2 = StringUtils.substringAfterLast((String)str2, (String)".");
            }
            str2 = this.unescapePropertyName(str2);
            temp = String.valueOf(str2) + "." + str1;
        }
        return temp;
    }

    private String unescapePropertyName(String propertyName) {
        return propertyName.replaceAll("-", ".");
    }
}

