/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.core.utils;

import com.zainta.core.model.PropertyFilter;
import com.zainta.core.utils.ReflectionUtils;
import com.zainta.core.utils.ServletUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class ActionUtils {
    private ActionUtils() {
    }

    public static <T, ID> void mergeByCheckedIds(Collection<T> srcObjects, Collection<ID> checkedIds, Class<T> clazz) {
        ActionUtils.mergeByCheckedIds(srcObjects, checkedIds, clazz, "id");
    }

    public static <T, ID> void mergeByCheckedIds(Collection<T> srcObjects, Collection<ID> checkedIds, Class<T> clazz, String idName) {
        Assert.notNull(srcObjects, (String)"scrObjects\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)idName, (String)"idName\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull(clazz, (String)"clazz\u4e0d\u80fd\u4e3a\u7a7a");
        if (checkedIds == null) {
            srcObjects.clear();
            return;
        }
        Iterator<T> srcIterator = srcObjects.iterator();
        try {
            while (srcIterator.hasNext()) {
                T element = srcIterator.next();
                Object id = PropertyUtils.getProperty(element, (String)idName);
                if (!checkedIds.contains(id)) {
                    srcIterator.remove();
                    continue;
                }
                checkedIds.remove(id);
            }
            for (ID id : checkedIds) {
                T obj = clazz.newInstance();
                PropertyUtils.setProperty(obj, (String)idName, id);
                srcObjects.add(obj);
            }
        }
        catch (Exception e) {
            throw ReflectionUtils.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static List<PropertyFilter> buildPropertyFilters(HttpServletRequest request) {
        return ActionUtils.buildPropertyFilters(request, "filter_");
    }

    public static List<PropertyFilter> buildPropertyFilters(HttpServletRequest request, String filterPrefix) {
        ArrayList<PropertyFilter> filterList = new ArrayList<PropertyFilter>();
        Map filterParamMap = ServletUtils.getParametersStartingWith(request, filterPrefix);
        for (Map.Entry entry : filterParamMap.entrySet()) {
            String filterName = (String)entry.getKey();
            Object value = entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)value.toString())) continue;
            PropertyFilter filter = new PropertyFilter(filterName, value);
            filter = value instanceof String ? new PropertyFilter(filterName, (String)value) : new PropertyFilter(filterName, (String[])value);
            filterList.add(filter);
        }
        return filterList;
    }

    public static String buildQueryString(HttpServletRequest request) {
        String queryString = "";
        if (request != null) {
            queryString = request.getQueryString();
            queryString = queryString == null ? "" : queryString.replaceAll("&page\\.pageNo=\\d+", "");
        }
        return queryString;
    }
}

