/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.core.model;

import com.zainta.core.utils.ReflectionUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.util.Assert;

public class PropertyFilter
implements Serializable {
    private static final long serialVersionUID = -4510669833710945026L;
    public static final String OR_SEPARATOR = "_OR_";
    private String[] propertyNames = null;
    private Class<?> propertyType = null;
    private Object propertyValue = null;
    private MatchType matchType = null;

    public PropertyFilter() {
    }

    private void buildPropertyFilterByFilterName(String filterName) {
        String matchTypeAndEnumTypeStr = StringUtils.substringBefore((String)filterName, (String)"_");
        String matchTypeStr = StringUtils.substringBefore((String)matchTypeAndEnumTypeStr, (String)"-");
        String matchTypeCode = StringUtils.substring((String)matchTypeStr, (int)0, (int)(matchTypeStr.length() - 1));
        String propertyTypeCode = StringUtils.substring((String)matchTypeStr, (int)(matchTypeStr.length() - 1), (int)matchTypeStr.length());
        try {
            this.matchType = Enum.valueOf(MatchType.class, matchTypeCode);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("filter\u540d\u79f0" + filterName + "\u6ca1\u6709\u6309\u89c4\u5219\u7f16\u5199,\u65e0\u6cd5\u5f97\u5230\u5c5e\u6027\u6bd4\u8f83\u7c7b\u578b.", e);
        }
        try {
            this.propertyType = Enum.valueOf(PropertyType.class, propertyTypeCode).getValue();
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("filter\u540d\u79f0" + filterName + "\u6ca1\u6709\u6309\u89c4\u5219\u7f16\u5199,\u65e0\u6cd5\u5f97\u5230\u5c5e\u6027\u503c\u7c7b\u578b.", e);
        }
        String propertyNameStr = StringUtils.substringAfter((String)filterName, (String)"_");
        this.propertyNames = propertyNameStr.split(OR_SEPARATOR);
        Assert.isTrue((this.propertyNames.length > 0 ? 1 : 0) != 0, (String)("filter\u540d\u79f0" + filterName + "\u6ca1\u6709\u6309\u89c4\u5219\u7f16\u5199,\u65e0\u6cd5\u5f97\u5230\u5c5e\u6027\u540d\u79f0."));
    }

    public PropertyFilter(String filterName, String value) {
        this.buildPropertyFilterByFilterName(filterName);
        String matchTypeAndEnumTypeStr = StringUtils.substringBefore((String)filterName, (String)"_");
        String matchTypeStr = StringUtils.substringBefore((String)matchTypeAndEnumTypeStr, (String)"-");
        String propertyTypeCode = StringUtils.substring((String)matchTypeStr, (int)(matchTypeStr.length() - 1), (int)matchTypeStr.length());
        String additionalType = StringUtils.substringAfter((String)matchTypeAndEnumTypeStr, (String)"-");
        if ("E".equals(propertyTypeCode)) {
            try {
                Class<?> c = Class.forName(additionalType);
                Method m = c.getMethod("valueOf", String.class);
                this.propertyValue = m.invoke(c, value);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            this.propertyValue = "T".equals(propertyTypeCode) ? DateUtils.addDays((Date)((Date)ReflectionUtils.convertStringToObject(value, this.propertyType)), (int)1) : ReflectionUtils.convertStringToObject(value, this.propertyType);
        }
    }

    public PropertyFilter(String filterName, String[] values) {
        this.buildPropertyFilterByFilterName(filterName);
        String matchTypeAndEnumTypeStr = StringUtils.substringBefore((String)filterName, (String)"_");
        String additionalType = StringUtils.substringAfter((String)matchTypeAndEnumTypeStr, (String)"-");
        Class<?> arrayType = PropertyType.valueOf(additionalType).getValue();
        Object[] theValues = new Object[values.length];
        int i = 0;
        while (i < values.length) {
            theValues[i] = this.propertyValue = ReflectionUtils.convertStringToObject(values[i], arrayType);
            ++i;
        }
        this.propertyValue = theValues;
    }

    public PropertyFilter(MatchType matchType, Class<?> propertyType, String[] propertyNames, Object propertyValue) {
        this.matchType = matchType;
        this.propertyType = propertyType;
        this.propertyNames = propertyNames;
        this.propertyValue = propertyValue;
    }

    public PropertyFilter(String filterName, Object value) {
        this.buildPropertyFilterByFilterName(filterName);
        this.propertyValue = value;
    }

    public boolean isMultiProperty() {
        return this.propertyNames.length > 1;
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public String getPropertyName() {
        if (this.propertyNames.length > 1) {
            throw new IllegalArgumentException("There are not only one property");
        }
        return this.propertyNames[0];
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public static enum MatchType {
        EQ,
        LIKE,
        LT,
        GT,
        LE,
        GE,
        NE,
        NL,
        NNL,
        IN;

    }

    public static enum PropertyType {
        S(String.class),
        I(Integer.class),
        L(Long.class),
        N(Double.class),
        D(Date.class),
        B(Boolean.class),
        E(Enum.class),
        C(BigDecimal.class),
        A(Object[].class),
        T(Date.class);

        private Class<?> clazz;

        private PropertyType(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Class<?> getValue() {
            return this.clazz;
        }
    }
}

