/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.api.reservation.beanmapper.converter;

import com.zainta.api.reservation.beanmapper.BeanMapper;
import com.zainta.api.reservation.beanmapper.converter.BeanConverter;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionBeanConverter
extends BeanConverter {
    private BeanMapper mapper;

    @Override
    public <T> Boolean isTypeMatched(Class<T> theClass) {
        if (Collection.class.isAssignableFrom(theClass)) {
            return true;
        }
        return false;
    }

    @Override
    public <T> T convert(Object sourceObject, Class<T> targetClass, Class<?> genericClass, String expand) {
        T target = null;
        try {
            target = targetClass.newInstance();
            Collection sourceCollection = (Collection)sourceObject;
            Collection targetCollection = (Collection)target;
            Iterator it = sourceCollection.iterator();
            while (it.hasNext()) {
                targetCollection.add(this.mapper.map(it.next(), genericClass, expand));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return target;
    }

    public void setMapper(BeanMapper mapper) {
        this.mapper = mapper;
    }
}

