/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.leancare.vip.utils;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringUtils {
    public static String replacePlaceHolder(String template, Map<String, String> valueMap) {
        if (template.indexOf("${") == -1) {
            return template;
        }
        while (true) {
            int start = template.indexOf("${");
            int end = template.indexOf("}", start);
            if (start == -1 || end == -1) break;
            String temp = template.substring(start + 2, end);
            if (valueMap.keySet().contains(temp)) {
                template = String.valueOf(template.substring(0, start)) + valueMap.get(temp) + template.substring(end + 1);
                continue;
            }
            template = String.valueOf(template.substring(0, start)) + template.substring(end + 1);
        }
        return template;
    }

    public static boolean hasPlaceHolder(String template) {
        return template.indexOf("${") != -1;
    }

    public static String connect(String ... parts) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            sb.append(part);
            ++n2;
        }
        return sb.toString();
    }

    public static String convertCamel(String template, String seperator) {
        StringBuffer result = new StringBuffer();
        if (template != null && template.length() > 0) {
            result.append(template.substring(0, 1).toLowerCase());
            int i = 1;
            while (i < template.length()) {
                String s = template.substring(i, i + 1);
                if (s.equals(s.toUpperCase()) && !s.equals(seperator)) {
                    result.append(seperator);
                    result.append(s.toLowerCase());
                } else {
                    result.append(s);
                }
                ++i;
            }
        }
        return result.toString();
    }

    public static String left(String string, int length) {
        return org.apache.commons.lang3.StringUtils.left((String)string, (int)length);
    }

    public static boolean isBlank(String string) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)string);
    }

    public static boolean isNotBlank(String string) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)string);
    }

    public static boolean isMobile(String mobile) {
        if (StringUtils.isBlank(mobile)) {
            return false;
        }
        Pattern pattern = Pattern.compile("1[3,4,5,8][0-9]{9}");
        Matcher matcher = pattern.matcher(mobile);
        return matcher.matches();
    }
}

