/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.leancare.vip.utils;

import com.zainta.leancare.vip.utils.PrimitiveUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public abstract class ReflectionUtils {
    public static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                fields.add(field);
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static void makeAccessible(Field field) {
        org.springframework.util.ReflectionUtils.makeAccessible((Field)field);
    }

    public static void setField(Field field, Object target, Object value) {
        ReflectionUtils.makeAccessible(field);
        org.springframework.util.ReflectionUtils.setField((Field)field, (Object)target, (Object)value);
    }

    public static void setField(Field field, Object target, String value) {
        ReflectionUtils.makeAccessible(field);
        Class<?> type = field.getType();
        if (String.class.equals(type)) {
            try {
                field.set(target, value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            Object convertedValue = PrimitiveUtils.parse(value, type);
            org.springframework.util.ReflectionUtils.setField((Field)field, (Object)target, (Object)convertedValue);
        }
    }
}

