/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.leancare.vip.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PrimitiveUtils {
    private static final Log logger = LogFactory.getLog(PrimitiveUtils.class);
    private static final Map<Class<?>, Class<?>> PRIMITIVE_COUNTERPARTS;
    private static final List<Class<?>> ACCEPTABLE_PRIMITIVE_TYPES;

    static {
        HashMap primitiveToWrapper = new HashMap<Class<?>, Class<?>>(){
            private static final long serialVersionUID = -177551230439661351L;
            {
                this.put(Integer.TYPE, Integer.class);
                this.put(Long.TYPE, Long.class);
                this.put(Boolean.TYPE, Boolean.class);
                this.put(Byte.TYPE, Byte.class);
                this.put(Short.TYPE, Short.class);
                this.put(Float.TYPE, Float.class);
                this.put(Double.TYPE, Double.class);
                this.put(Character.TYPE, Character.class);
            }
        };
        HashMap<Class, Class> counterparts = new HashMap<Class, Class>();
        for (Map.Entry entry : primitiveToWrapper.entrySet()) {
            Class key = (Class)entry.getKey();
            Class value = (Class)entry.getValue();
            counterparts.put(key, value);
            counterparts.put(value, key);
        }
        PRIMITIVE_COUNTERPARTS = Collections.unmodifiableMap(counterparts);
        ArrayList acceptablePrimitiveTypes = new ArrayList();
        acceptablePrimitiveTypes.addAll(PRIMITIVE_COUNTERPARTS.keySet());
        acceptablePrimitiveTypes.add(String.class);
        acceptablePrimitiveTypes.add(Date.class);
        acceptablePrimitiveTypes.add(BigDecimal.class);
        ACCEPTABLE_PRIMITIVE_TYPES = Collections.unmodifiableList(acceptablePrimitiveTypes);
    }

    public static Object parse(String value, Class<?> type) {
        if (value == null) {
            return null;
        }
        if (type.isPrimitive()) {
            try {
                Class<?> wrapper = PRIMITIVE_COUNTERPARTS.get(type);
                Method parser = wrapper.getMethod("parse" + StringUtils.capitalize((String)type.getName()), String.class);
                return parser.invoke(null, value);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new AssertionError((Object)("Not Supported Type: " + type));
    }

    public static boolean isAcceptablePrimitiveType(Class clazz) {
        return ACCEPTABLE_PRIMITIVE_TYPES.contains(clazz) || clazz.isEnum();
    }
}

