/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.leancare.vip.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpUtils {
    private static final Log logger = LogFactory.getLog(HttpUtils.class);

    public static String get(String url, Map<String, String> params, boolean log) {
        return HttpUtils.get(url, params, "GBK", log);
    }

    public static String get(String url, Map<String, String> params) {
        return HttpUtils.get(url, params, "GBK", true);
    }

    public static String get(String url, Map<String, String> params, String encode, boolean log) {
        return HttpUtils.connect(url, params, HttpMethods.GET, encode, log);
    }

    public static String get(String url, Map<String, String> params, String encode) {
        return HttpUtils.connect(url, params, HttpMethods.GET, encode, true);
    }

    public static String post(String url, Map<String, String> params, boolean log) {
        return HttpUtils.post(url, params, "GBK", log);
    }

    public static String post(String url, Map<String, String> params) {
        return HttpUtils.post(url, params, "GBK", true);
    }

    public static String post(String url, Map<String, String> params, String encode, boolean log) {
        return HttpUtils.connect(url, params, HttpMethods.POST, encode, log);
    }

    public static String post(String url, Map<String, String> params, String encode) {
        return HttpUtils.connect(url, params, HttpMethods.POST, encode, true);
    }

    private static String connect(String url, Map<String, String> params, HttpMethods method, String encode, boolean log) {
        if (StringUtils.isBlank((CharSequence)url)) {
            logger.error((Object)"connect url is null");
            return null;
        }
        if (!url.startsWith("http://")) {
            url = "http://" + url;
        }
        HttpClient client = new HttpClient();
        client.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        client.getHttpConnectionManager().getParams().setSoTimeout(30000);
        HttpMethod httpMethod = method.equals((Object)HttpMethods.POST) ? HttpUtils.getPostMethod(url, params) : HttpUtils.getGetMethod(url, params, encode);
        httpMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
        httpMethod.getParams().setContentCharset(encode);
        try {
            int statusCode;
            if (log) {
                logger.info((Object)("connect url: " + httpMethod.getURI()));
            }
            if ((statusCode = client.executeMethod(httpMethod)) != 200) {
                return null;
            }
            String string = httpMethod.getResponseBodyAsString();
            return string;
        }
        catch (Exception e) {
            logger.error((Object)("error url:" + url + "-----" + e));
        }
        finally {
            httpMethod.releaseConnection();
        }
        return null;
    }

    private static NameValuePair[] getNameValuePairs(Map<String, String> params) {
        NameValuePair[] nameValueArray = new NameValuePair[params.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            nameValueArray[i++] = new NameValuePair(entry.getKey(), entry.getValue());
        }
        return nameValueArray;
    }

    private static HttpMethod getPostMethod(String url, Map<String, String> params) {
        PostMethod post = new PostMethod(url);
        if (params == null) {
            return post;
        }
        post.addParameters(HttpUtils.getNameValuePairs(params));
        return post;
    }

    private static HttpMethod getGetMethod(String url, Map<String, String> params, String encode) {
        if (params != null) {
            StringBuilder sb = new StringBuilder("?");
            for (Map.Entry<String, String> entry : params.entrySet()) {
                sb.append(entry.getKey()).append("=");
                try {
                    sb.append(URLEncoder.encode(entry.getValue(), encode)).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    sb.append(entry.getValue()).append("&");
                }
            }
            url = String.valueOf(url) + sb.substring(0, sb.length() - 1).replace("\n", "").replace("\r\n", "");
        }
        GetMethod get = new GetMethod(url);
        return get;
    }

    public static enum HttpMethods {
        POST,
        GET;

    }
}

