/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.leancare.vip.utils;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;

public abstract class FreeMarkerUtils {
    private static final Log logger = LogFactory.getLog(FreeMarkerUtils.class);

    public static String processTemplateFile(String filePath, Map<String, Object> root) {
        StringWriter sw = new StringWriter();
        String result = "";
        Configuration cfg = new Configuration();
        cfg.setEncoding(Locale.CHINA, "UTF-8");
        try {
            cfg.setDirectoryForTemplateLoading(new ClassPathResource("").getFile());
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException("FreeMarker template directory error");
        }
        try {
            try {
                Template ftl = cfg.getTemplate(filePath, Locale.CHINA, "UTF-8");
                try {
                    ftl.process(root, (Writer)sw);
                    result = sw.toString();
                }
                catch (TemplateException e) {
                    logger.error((Object)("tempalte exception:" + e.getMessage()));
                    throw new RuntimeException("FreeMarker template process failed" + e.getMessage());
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage());
                throw new RuntimeException("FreeMarker template file parse error");
            }
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return result;
    }

    public static String processTemplate(Map root, String templateName, String templateString) {
        StringWriter sw = new StringWriter();
        String result = "";
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        stringLoader.putTemplate(templateName, templateString);
        Configuration cfg = new Configuration();
        cfg.setEncoding(Locale.CHINA, "UTF-8");
        cfg.setTemplateLoader((TemplateLoader)stringLoader);
        try {
            try {
                Template ftl = cfg.getTemplate(templateName, Locale.CHINA, "UTF-8");
                try {
                    ftl.process((Object)root, (Writer)sw);
                    result = sw.toString();
                }
                catch (TemplateException e) {
                    logger.error((Object)e.getMessage());
                    throw new RuntimeException("FreeMarker template process failed");
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage());
                throw new RuntimeException("FreeMarker template file parse error");
            }
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return result;
    }

    public static String processTemplate(Map root, String templateString) {
        return FreeMarkerUtils.processTemplate(root, "default", templateString);
    }
}

