/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.leancare.vip.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class DateUtils {
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static final long SECOND = 86400000L;

    public static Date addDay(Date date, int day) {
        return org.apache.commons.lang3.time.DateUtils.addDays((Date)date, (int)day);
    }

    public static Date addWeek(Date date, int week) {
        return org.apache.commons.lang3.time.DateUtils.addWeeks((Date)date, (int)week);
    }

    public static Date addMonth(Date date, int month) {
        return org.apache.commons.lang3.time.DateUtils.addMonths((Date)date, (int)month);
    }

    public static Date addYear(Date date, int year) {
        return org.apache.commons.lang3.time.DateUtils.addYears((Date)date, (int)year);
    }

    public static Date parseDate(String dateString, String pattern) {
        return DateUtils.parseDate(dateString, new String[]{pattern});
    }

    public static Date parseDate(String dateString, String[] patterns) {
        try {
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)dateString, (String[])patterns);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseDate(int year, int month, int date) {
        return DateUtils.parseDate(DateUtils.format(year, month, date), DEFAULT_DATE_PATTERN);
    }

    public static Date parseDate(String dateString) {
        int year = Integer.parseInt(dateString.substring(0, 4));
        int month = Integer.parseInt(dateString.substring(4, 6));
        int date = Integer.parseInt(dateString.substring(6, 8));
        return DateUtils.parseDate(DateUtils.format(year, month, date), DEFAULT_DATE_PATTERN);
    }

    public static String format(int year, int month, int date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, date);
        return new SimpleDateFormat(DEFAULT_DATE_PATTERN).format(calendar.getTime());
    }

    public static String format(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        return new SimpleDateFormat("yyyy-MM").format(calendar.getTime());
    }

    public static String format(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new SimpleDateFormat(DEFAULT_DATE_PATTERN).format(calendar.getTime());
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new SimpleDateFormat(pattern).format(calendar.getTime());
    }

    public static String formatHm(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new SimpleDateFormat("HH:mm").format(calendar.getTime());
    }

    public static String getCurrentTimeMillis() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static Date getFirstMonthDayForCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.setFirstDayOfWeek(0);
        calendar.add(6, -(calendar.get(7) - 1));
        return calendar.getTime();
    }

    public static Date getLastMonthDayForCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.setFirstDayOfWeek(0);
        calendar.add(6, 7 - calendar.get(7));
        return calendar.getTime();
    }

    public static int getMonthDay(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        return calendar.getActualMaximum(5);
    }

    public static String getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(1));
    }

    public static String getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2) + 1;
        return month < 10 ? "0" + month : "" + month;
    }

    public static String getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(5));
    }

    public static Date getFirstDayOfYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(6, 1);
        return calendar.getTime();
    }

    public static Date getFirstDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameMonth(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(2) == cal2.get(2);
    }

    public static boolean isSameYear(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1);
    }

    public static List<Date> getIntervalDays(Date start, Date end) {
        ArrayList<Date> dates = new ArrayList<Date>();
        if (start.after(end)) {
            throw new IllegalArgumentException("The start date must not be after end date");
        }
        Date date = start;
        while (!DateUtils.isSameDay(date, end)) {
            dates.add(date);
            date = org.apache.commons.lang3.time.DateUtils.addDays((Date)date, (int)1);
        }
        dates.add(end);
        return dates;
    }

    public static List<Date> getIntervalMonths(Date start, Date end) {
        ArrayList<Date> dates = new ArrayList<Date>();
        if (start.after(end)) {
            throw new IllegalArgumentException("The start date must not be after end date");
        }
        Date date = start;
        while (!DateUtils.isSameMonth(date, end)) {
            dates.add(date);
            date = org.apache.commons.lang3.time.DateUtils.addMonths((Date)date, (int)1);
        }
        dates.add(end);
        return dates;
    }

    public static Date getDate(Date date) {
        return DateUtils.parseDate(DateUtils.format(date, "yyyyMMdd"), "yyyyMMdd");
    }

    public static int subTwoDateDay(Date end, Date start) {
        if (start.after(end)) {
            throw new IllegalArgumentException("The start date must not be after end date");
        }
        long times = end.getTime() - start.getTime();
        return (int)(times / 86400000L);
    }

    public static int subTwoDateYear(Date end, Date start) {
        if (start.after(end)) {
            throw new IllegalArgumentException("The start date must not be after end date");
        }
        long times = end.getTime() - start.getTime();
        return (int)(times / 31536000000L);
    }

    public static Date endYearDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(DateUtils.getYear(date)), 11, 31, 23, 59, 59);
        return DateUtils.parseDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calendar.getTime()), "yyyy-MM-dd HH:mm:ss");
    }

    public static Date parserDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(DateUtils.getYear(date)), Integer.parseInt(DateUtils.getMonth(date)) - 1, Integer.parseInt(DateUtils.getDay(date)), calendar.get(11), calendar.get(12), calendar.get(13));
        return DateUtils.parseDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calendar.getTime()), "yyyy-MM-dd HH:mm:ss");
    }

    public static Date getTodayFirstDay() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getTodayLastDay() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 24);
        cal.set(13, -1);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getTomorrowFirstDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getTomorrowLastDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        cal.set(11, 24);
        cal.set(13, -1);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getWeekFirstDay() {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 2);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getWeekLastDay() {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 7);
        cal.add(5, 2);
        cal.set(11, 0);
        cal.set(13, -1);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getMonthFirstDay() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(5, cal.getActualMinimum(5));
        return cal.getTime();
    }

    public static Date getMonthLastDay() {
        Calendar cal = Calendar.getInstance();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, -1);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 24);
        return cal.getTime();
    }

    public static Date getDateByIdCardNumber(String val) {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        if ("" == val || val == null) {
            return null;
        }
        try {
            String birthday = "";
            if (15 == val.length()) {
                birthday = String.valueOf(val.charAt(6)) + val.charAt(7);
                birthday = Integer.parseInt(birthday) < 10 ? "20" + birthday : "19" + birthday;
                birthday = String.valueOf(birthday) + "-" + val.charAt(8) + val.charAt(9) + "-" + val.charAt(10) + val.charAt(11);
                date = sdf.parse(birthday);
            }
            if (18 == val.length()) {
                birthday = String.valueOf(val.charAt(6)) + val.charAt(7) + val.charAt(8) + val.charAt(9) + "-" + val.charAt(10) + val.charAt(11) + "-" + val.charAt(12) + val.charAt(13);
                date = sdf.parse(birthday);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date getMonthsBeforeDate(Integer months) {
        Calendar c = Calendar.getInstance();
        c.add(2, -months.intValue());
        Date date = c.getTime();
        return date;
    }

    public static Date getTargetFormatDate(Date targerDate, Date date2) {
        String d1 = DateUtils.format(targerDate, DEFAULT_DATE_PATTERN);
        String d2 = DateUtils.format(date2, "HH:mm:ss");
        String newDate = String.valueOf(d1) + " " + d2;
        date2 = DateUtils.parseDate(newDate, "yyyy-MM-dd HH:mm:ss");
        return date2;
    }

    public static Date getTargetFormatYearDate(Date targetDate, Date date2) {
        String d1 = DateUtils.format(targetDate, "yyyy");
        String d2 = DateUtils.format(date2, "-MM-dd HH:mm:ss");
        String newDate = String.valueOf(Integer.parseInt(d1)) + d2;
        date2 = DateUtils.parseDate(newDate, "yyyy-MM-dd HH:mm:ss");
        return date2;
    }

    public static Date addMinutes(Date date, int minutes) {
        return org.apache.commons.lang3.time.DateUtils.addMinutes((Date)date, (int)minutes);
    }

    public static Date addSeconds(Date date, int seconds) {
        return org.apache.commons.lang3.time.DateUtils.addSeconds((Date)date, (int)seconds);
    }

    public static Date addHours(Date date, int hours) {
        return org.apache.commons.lang3.time.DateUtils.addHours((Date)date, (int)hours);
    }

    public static Date endDayDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(DateUtils.getYear(date)), Integer.parseInt(DateUtils.getMonth(date)) - 1, Integer.parseInt(DateUtils.getDay(date)), 23, 59, 59);
        return DateUtils.parseDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calendar.getTime()), "yyyy-MM-dd HH:mm:ss");
    }

    public static Date startDayDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(DateUtils.getYear(date)), Integer.parseInt(DateUtils.getMonth(date)) - 1, Integer.parseInt(DateUtils.getDay(date)), 0, 0, 0);
        return DateUtils.parseDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calendar.getTime()), "yyyy-MM-dd HH:mm:ss");
    }

    public static Boolean isCurrentDateLaterEqualThanTheDate(Date theDate) {
        Date currentDate = new Date();
        Date thisYearTheDate = DateUtils.getTargetFormatDate(theDate, currentDate);
        if (currentDate.compareTo(thisYearTheDate) >= 0) {
            return true;
        }
        return false;
    }
}

