/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.leancare.vip.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BeanUtils {
    private static final Log logger = LogFactory.getLog(BeanUtils.class);

    public static void copyProperties(Object dest, Object source) {
        try {
            PropertyUtils.copyProperties((Object)dest, (Object)source);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public static void populate(Object bean, Map properties) {
        try {
            org.apache.commons.beanutils.BeanUtils.populate((Object)bean, (Map)properties);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Map describe(Object bean) {
        Map result = new HashMap();
        try {
            result = org.apache.commons.beanutils.BeanUtils.describe((Object)bean);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void copyBean(Object dest, Object source) {
        try {
            org.apache.commons.beanutils.BeanUtils.copyProperties((Object)dest, (Object)source);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static boolean isPropertyNotEmpty(Object bean, String property) {
        return BeanUtils.isPropertyNotEmpty(bean, property, "id");
    }

    public static boolean isPropertyNotEmpty(Object bean, String property, String nestedCheckProperty) {
        if (bean == null) {
            return false;
        }
        try {
            Object id;
            Object target = PropertyUtils.getProperty((Object)bean, (String)property);
            if (target != null && (id = PropertyUtils.getProperty((Object)target, (String)nestedCheckProperty)) != null && id instanceof String && StringUtils.isNotBlank((CharSequence)((String)id))) {
                return true;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isArrayEmpty(String[] array) {
        boolean result = true;
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (StringUtils.isNotBlank((CharSequence)array[i])) {
                    return false;
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean isArrayContainsSingleValue(String[] array) {
        if (array == null) {
            return false;
        }
        return array.length == 1;
    }

    public static List extractPropertyList(Collection bean, String property) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator iter = bean.iterator();
        while (iter.hasNext()) {
            try {
                result.add(PropertyUtils.getProperty(iter.next(), (String)property));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

