/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.transaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.logging.jdbc.ConnectionLogger;
import org.apache.ibatis.transaction.Transaction;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.util.Assert;

public class SpringManagedTransaction
implements Transaction {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Connection connection;
    private final Connection unwrappedConnection;
    private final DataSource dataSource;
    private final boolean isConnectionTransactional;

    public SpringManagedTransaction(Connection connection, DataSource dataSource) {
        Assert.notNull((Object)connection, (String)"No Connection specified");
        Assert.notNull((Object)dataSource, (String)"No DataSource specified");
        this.connection = connection;
        this.dataSource = dataSource;
        this.unwrappedConnection = this.unwrapConnection(connection);
        this.isConnectionTransactional = DataSourceUtils.isConnectionTransactional((Connection)this.unwrappedConnection, (DataSource)dataSource);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("JDBC Connection [" + this.connection + "] will" + (this.isConnectionTransactional ? " " : " not ") + "be managed by Spring");
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void commit() throws SQLException {
        if (!this.isConnectionTransactional) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Committing JDBC Connection [" + this.connection + "]");
            }
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (!this.isConnectionTransactional) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Rolling back JDBC Connection [" + this.connection + "]");
            }
            this.connection.rollback();
        }
    }

    public void close() throws SQLException {
        DataSourceUtils.releaseConnection((Connection)this.unwrappedConnection, (DataSource)this.dataSource);
    }

    private Connection unwrapConnection(Connection connection) {
        InvocationHandler handler;
        if (Proxy.isProxyClass(connection.getClass()) && (handler = Proxy.getInvocationHandler(connection)) instanceof ConnectionLogger) {
            return ((ConnectionLogger)handler).getConnection();
        }
        return connection;
    }
}

