/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.camel.util.ObjectHelper;

public final class JmsMessageHelper {
    private JmsMessageHelper() {
    }

    public static Object removeJmsProperty(Message jmsMessage, String name) throws JMSException {
        if (!jmsMessage.propertyExists(name)) {
            return null;
        }
        String answer = null;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Enumeration en = jmsMessage.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (name.equals(key)) {
                answer = key;
                continue;
            }
            map.put(key, jmsMessage.getObjectProperty(key));
        }
        jmsMessage.clearProperties();
        for (Map.Entry entry : map.entrySet()) {
            jmsMessage.setObjectProperty((String)entry.getKey(), entry.getValue());
        }
        return answer;
    }

    public static boolean hasProperty(Message jmsMessage, String name) throws JMSException {
        Enumeration en = jmsMessage.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!name.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static void setProperty(Message jmsMessage, String name, Object value) throws JMSException {
        if (value == null) {
            return;
        }
        if (value instanceof Byte) {
            jmsMessage.setByteProperty(name, ((Byte)value).byteValue());
        } else if (value instanceof Boolean) {
            jmsMessage.setBooleanProperty(name, ((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            jmsMessage.setDoubleProperty(name, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            jmsMessage.setFloatProperty(name, ((Float)value).floatValue());
        } else if (value instanceof Integer) {
            jmsMessage.setIntProperty(name, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            jmsMessage.setLongProperty(name, ((Long)value).longValue());
        } else if (value instanceof Short) {
            jmsMessage.setShortProperty(name, ((Short)value).shortValue());
        } else if (value instanceof String) {
            jmsMessage.setStringProperty(name, (String)value);
        } else {
            jmsMessage.setObjectProperty(name, value);
        }
    }

    public static void setCorrelationId(Message message, String correlationId) {
        try {
            message.setJMSCorrelationID(correlationId);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public static String normalizeDestinationName(String destination) {
        if (ObjectHelper.isEmpty((Object)destination)) {
            return destination;
        }
        if (destination.startsWith("queue:")) {
            return ObjectHelper.removeStartingCharacters((String)destination.substring("queue:".length()), (char)'/');
        }
        if (destination.startsWith("topic:")) {
            return ObjectHelper.removeStartingCharacters((String)destination.substring("topic:".length()), (char)'/');
        }
        return destination;
    }

    public static void setJMSReplyTo(Message message, Destination replyTo) {
        try {
            message.setJMSReplyTo(replyTo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Destination getJMSReplyTo(Message message) {
        try {
            return message.getJMSReplyTo();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getJMSType(Message message) {
        try {
            return message.getJMSType();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

