/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.test.utils;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.scalar.ScalarSerializer;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.DefaultResourceLoader;

public class YamlFileUtils {
    private static YamlReader reader;
    private static YamlConfig config;

    static {
        config = new YamlConfig();
        config.setScalarSerializer(BigDecimal.class, (ScalarSerializer)new BigDecimalYamlSerializer());
    }

    public static <T> T getYamlObject(Class<T> clazz, String fileURL) {
        try {
            reader = new YamlReader((Reader)new InputStreamReader(new DefaultResourceLoader().getResource(fileURL).getInputStream(), "UTF-8"), config);
            return (T)reader.read(clazz);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (YamlException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> List<T> getYamlList(Class<T> clazz, String fileURL) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            Object object;
            reader = new YamlReader((Reader)new InputStreamReader(new DefaultResourceLoader().getResource(fileURL).getInputStream(), "UTF-8"), config);
            while ((object = reader.read(clazz)) != null) {
                list.add(object);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (YamlException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    static class BigDecimalYamlSerializer
    implements ScalarSerializer<BigDecimal> {
        BigDecimalYamlSerializer() {
        }

        public String write(BigDecimal bd) throws YamlException {
            return bd.toString();
        }

        public BigDecimal read(String value) throws YamlException {
            return new BigDecimal(value);
        }
    }
}

