/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.test.data;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.ext.h2.H2Connection;
import org.dbunit.ext.mysql.MySqlConnection;
import org.dbunit.ext.oracle.OracleConnection;
import org.dbunit.operation.DatabaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class DataFixtures {
    private static Logger logger = LoggerFactory.getLogger(DataFixtures.class);
    private static ResourceLoader resourceLoader = new DefaultResourceLoader();

    public static void reloadData(DataSource dataSource, String ... xmlFilePaths) throws Exception {
        DataFixtures.execute(DatabaseOperation.CLEAN_INSERT, dataSource, xmlFilePaths);
    }

    public static void loadData(DataSource dataSource, String ... xmlFilePaths) throws Exception {
        DataFixtures.execute(DatabaseOperation.INSERT, dataSource, xmlFilePaths);
    }

    public static void deleteData(DataSource dataSource, String ... xmlFilePaths) throws Exception {
        DataFixtures.execute(DatabaseOperation.DELETE_ALL, dataSource, xmlFilePaths);
    }

    private static void execute(DatabaseOperation operation, DataSource dataSource, String ... xmlFilePaths) throws DatabaseUnitException, SQLException {
        IDatabaseConnection connection = DataFixtures.getConnection(dataSource);
        try {
            try {
                String[] stringArray = xmlFilePaths;
                int n = xmlFilePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String xmlPath = stringArray[n2];
                    try {
                        InputStream input = resourceLoader.getResource(xmlPath).getInputStream();
                        FlatXmlDataSet dataSet = new FlatXmlDataSetBuilder().setColumnSensing(true).build(input);
                        operation.execute(connection, (IDataSet)dataSet);
                        connection.getConnection().commit();
                    }
                    catch (IOException e) {
                        logger.warn(String.valueOf(xmlPath) + " file not found", (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                if (connection != null) {
                    connection.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    protected static IDatabaseConnection getConnection(DataSource dataSource) throws DatabaseUnitException, SQLException {
        Connection connection = dataSource.getConnection();
        String jdbcUrl = connection.getMetaData().getURL();
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":h2:")) {
            return new H2Connection(connection, null);
        }
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":mysql:")) {
            return new MySqlConnection(connection, null);
        }
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)":oracle:")) {
            return new OracleConnection(connection, null);
        }
        return new DatabaseConnection(connection);
    }
}

