/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.olap.sqlbuilder;

import com.zainta.olap.Cube;
import com.zainta.olap.Dimension;
import com.zainta.olap.Fact;
import com.zainta.olap.sqlbuilder.AbstractSqlBuilder;
import com.zainta.olap.util.StringUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PostgresqlBuilder
extends AbstractSqlBuilder {
    public String buildSelectStatementByFact(Fact fact) {
        String factSelect = null;
        switch (fact.getAggregate()) {
            case COUNT: {
                if (StringUtils.isBlank((CharSequence)fact.getFilter())) {
                    factSelect = "count(" + fact.getFactField() + ")";
                    break;
                }
                factSelect = "sum(case when " + this.buildFactFilterStatement(fact) + " then 1 else 0 end)";
                break;
            }
            case SUM: {
                if (StringUtils.isBlank((CharSequence)fact.getFilter())) {
                    factSelect = "sum(" + fact.getFactField() + ")";
                    break;
                }
                factSelect = "sum(case when " + this.buildFactFilterStatement(fact) + " then " + fact.getFactField() + " else 0 end)";
                break;
            }
            case AVG: {
                if (StringUtils.isBlank((CharSequence)fact.getFilter())) {
                    factSelect = "avg(" + fact.getFactField() + ")";
                    break;
                }
                factSelect = "avg(case when " + this.buildFactFilterStatement(fact) + " then " + fact.getFactField() + " else null end)";
                break;
            }
            case MAX: {
                if (StringUtils.isBlank((CharSequence)fact.getFilter())) {
                    factSelect = "max(" + fact.getFactField() + ")";
                    break;
                }
                factSelect = "max(case when " + this.buildFactFilterStatement(fact) + " then " + fact.getFactField() + " else 0 end)";
                break;
            }
            default: {
                factSelect = StringUtils.isBlank((CharSequence)fact.getFilter()) ? "min(" + fact.getFactField() + ")" : "min(case when " + this.buildFactFilterStatement(fact) + " then " + fact.getFactField() + " else 0 end)";
            }
        }
        return factSelect + " as " + "\"" + fact.getFactName() + "\"";
    }

    private String buildFactFilterStatement(Fact fact) {
        return fact.getFilter();
    }

    public String buildDateJoinStatement(String factTable, Dimension dimension) {
        if (!dimension.getTable().equalsIgnoreCase("date_dimension")) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String joinType = " left join ";
        if (dimension.isRight()) {
            joinType = " full outer join ";
        }
        sb.append(joinType).append(dimension.getTable()).append(" on ").append(" extract(year from ").append(factTable).append(".").append(dimension.getForeignKey()).append(")").append("=").append(dimension.getTable()).append(".").append("year").append(" and extract(month from ").append(factTable).append(".").append(dimension.getForeignKey()).append(")").append("=").append(dimension.getTable()).append(".").append("month").append(" and extract(day from ").append(factTable).append(".").append(dimension.getForeignKey()).append(")").append("=").append(dimension.getTable()).append(".").append("day");
        return sb.toString();
    }

    public String buildSelectStatementByComputedFact(Cube cube, Fact fact) {
        List<String> factNames = StringUtil.getMatchedGroups(fact.getCalculation(), "(\\w+)");
        String statement = fact.getCalculation() + " as " + fact.getFactName();
        String[] divisors = fact.getCalculation().split("/");
        if (divisors.length > 1) {
            String judge0 = "";
            for (int i = 1; i < divisors.length; ++i) {
                if (judge0.length() > 0) {
                    judge0 = judge0 + " or ";
                }
                judge0 = judge0 + divisors[i] + " = 0 ";
            }
            statement = " case when " + judge0 + " then 0 else " + fact.getCalculation() + " end as \"" + fact.getFactName() + "\"";
        }
        for (String factName : factNames) {
            Fact theFact = cube.getFact(factName);
            if (theFact == null) continue;
            statement = statement.replaceAll("\\b" + factName + "\\b", this.buildSelectStatementByFact(theFact).replaceAll("as\\s+\"\\w+\"", "::real"));
        }
        return statement;
    }
}

