/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.olap;

import com.zainta.olap.Cube;
import com.zainta.olap.Dimension;
import com.zainta.olap.Fact;
import com.zainta.olap.Level;
import com.zainta.olap.SqlBuilder;
import com.zainta.olap.util.StringUtil;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlapReporter {
    private JdbcTemplate jdbcTemplate;
    private SqlBuilder sqlBuilder;

    public List<Map<String, Object>> report(Cube cube, String factsString, String dimensionsString, String filter) {
        Set<Fact> facts = cube.getFactsFromFactNameString(factsString);
        List<Level> levels = cube.getLevelsFromDimensionString(dimensionsString);
        String sql = this.getSql(cube, facts, levels, filter);
        List resultWithDimensionId = this.jdbcTemplate.queryForList(sql);
        List<Map<String, Object>> resultWithoutSummary = this.replaceDimensionIdWithLabel(resultWithDimensionId, levels);
        List<Map<String, Object>> result = this.addSummaryToResult(cube, resultWithoutSummary);
        return result;
    }

    private List<Map<String, Object>> replaceDimensionIdWithLabel(List<Map<String, Object>> resultWithDimensionId, List<Level> levels) {
        for (Level level : levels) {
            HashMap<Integer, String> idLabelMap = new HashMap<Integer, String>();
            for (Map<String, Object> record : resultWithDimensionId) {
                Object rawId = record.get(level.getDimensionLevelName());
                Integer levelId = null;
                String levelLabel = null;
                levelId = rawId.getClass() == Double.class ? Integer.valueOf(((Double)rawId).intValue()) : (Integer)record.get(level.getDimensionLevelName());
                if (idLabelMap.containsKey(levelId)) {
                    levelLabel = (String)idLabelMap.get(levelId);
                } else {
                    String sql = this.sqlBuilder.buildDimensionLabelStatement(level, levelId);
                    levelLabel = (String)this.jdbcTemplate.queryForObject(sql, (RowMapper)new RowMapper<String>(){

                        public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                            return rs.getString(1);
                        }
                    });
                    idLabelMap.put(levelId, levelLabel);
                }
                record.put(level.getDimensionLevelName(), levelLabel);
            }
        }
        return resultWithDimensionId;
    }

    public String getSql(Cube cube, String factsString, String dimensionsString, String filter) {
        Set<Fact> facts = cube.getFactsFromFactNameString(factsString);
        List<Level> levels = cube.getLevelsFromDimensionString(dimensionsString);
        return this.getSql(cube, facts, levels, filter);
    }

    private String getSql(Cube cube, Set<Fact> facts, List<Level> levels, String filter) {
        StringBuilder sb = new StringBuilder();
        String sql = sb.append(this.buildSelectStatement(cube, facts, levels)).append(this.buildFromStatement(cube)).append(this.buildJoinStatement(cube, levels, filter)).append(this.buildWhereStatement(cube, filter)).append(this.buildGroupStatement(cube, levels)).append(this.buildOrderStatement(cube, levels)).toString();
        return sql;
    }

    private List<Map<String, Object>> addSummaryToResult(Cube cube, List<Map<String, Object>> resultWithoutSummary) {
        if (resultWithoutSummary.size() == 0) {
            return resultWithoutSummary;
        }
        HashMap<String, Object> totalSummary = new HashMap<String, Object>();
        HashMap<String, Object> averageSummary = new HashMap<String, Object>();
        for (Map<String, Object> record : resultWithoutSummary) {
            for (String key : record.keySet()) {
                if (record.get(key) == null) {
                    record.put(key, "0");
                }
                if (key.contains(":")) {
                    if (totalSummary.containsKey(key)) continue;
                    totalSummary.put(key, "total");
                    continue;
                }
                if (!totalSummary.containsKey(key)) {
                    totalSummary.put(key, record.get(key));
                    continue;
                }
                totalSummary.put(key, this.addObjects(record.get(key), totalSummary.get(key)));
            }
        }
        for (String key : totalSummary.keySet()) {
            Fact fact = cube.getFact(key);
            if (fact != null && fact.getCalculation().split("/").length > 1) {
                List<String> factNames = StringUtil.getMatchedGroups(fact.getCalculation(), "(\\w+)");
                BigDecimal rate = new BigDecimal(totalSummary.get(factNames.get(0)).toString());
                for (int i = 1; i < factNames.size(); ++i) {
                    if (totalSummary.get(factNames.get(i)).toString().equals("0")) {
                        rate = BigDecimal.ZERO;
                        break;
                    }
                    rate = rate.divide(new BigDecimal(totalSummary.get(factNames.get(i)).toString()), 2, 5);
                }
                totalSummary.put(fact.getFactName(), rate);
                averageSummary.put(fact.getFactName(), rate);
                continue;
            }
            if (key.contains(":")) {
                averageSummary.put(key, "average");
                continue;
            }
            averageSummary.put(key, this.divideObject(totalSummary.get(key), resultWithoutSummary.size()));
        }
        resultWithoutSummary.add(totalSummary);
        resultWithoutSummary.add(averageSummary);
        return resultWithoutSummary;
    }

    private Object addObjects(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2;
        }
        if (obj2 == null) {
            return obj1;
        }
        if (obj1 instanceof Integer && obj2 instanceof Integer) {
            return (Integer)obj1 + (Integer)obj2;
        }
        if (obj1 instanceof Long && obj2 instanceof Long) {
            return (Long)obj1 + (Long)obj2;
        }
        if (obj1 instanceof Double && obj2 instanceof Double) {
            return (Double)obj1 + (Double)obj2;
        }
        if (obj1 instanceof Float && obj2 instanceof Float) {
            return Float.valueOf(((Float)obj1).floatValue() + ((Float)obj2).floatValue());
        }
        return new BigDecimal(obj1.toString()).add(new BigDecimal(obj2.toString()));
    }

    private Float divideObject(Object obj, int divisor) {
        if (obj instanceof Integer) {
            return Float.valueOf(((Integer)obj).floatValue() / (float)divisor);
        }
        if (obj instanceof Long) {
            return Float.valueOf(((Long)obj).floatValue() / (float)divisor);
        }
        if (obj instanceof Double) {
            return Float.valueOf(((Double)obj).floatValue() / (float)divisor);
        }
        if (obj instanceof Float) {
            return Float.valueOf(((Float)obj).floatValue() / (float)divisor);
        }
        return Float.valueOf(new BigDecimal(obj.toString()).floatValue() / (float)divisor);
    }

    public String buildSelectStatement(Cube cube, Set<Fact> facts, List<Level> levels) {
        StringBuilder sb = new StringBuilder("select ");
        LinkedList<String> selectors = new LinkedList<String>();
        for (Level level : levels) {
            selectors.add(this.sqlBuilder.buildSelectStatementByLevel(level));
        }
        for (Fact fact : facts) {
            if (fact.isComputed()) continue;
            selectors.add(this.sqlBuilder.buildSelectStatementByFact(fact));
        }
        for (Fact fact : facts) {
            if (!fact.isComputed()) continue;
            selectors.add(this.sqlBuilder.buildSelectStatementByComputedFact(cube, fact));
        }
        sb.append(StringUtils.join(selectors, (String)","));
        return sb.toString();
    }

    public String buildFromStatement(Cube cube) {
        return " from " + cube.getFactTable();
    }

    public String buildJoinStatement(Cube cube, List<Level> levels, String filter) {
        HashSet<Dimension> dimensions = new HashSet<Dimension>();
        for (Level level : levels) {
            dimensions.add(level.getDimension());
        }
        for (String dimensionName : StringUtil.getMatchedGroups(filter, "(\\w+)[:\\.]")) {
            if (cube.getDimension(dimensionName) != null) {
                dimensions.add(cube.getDimension(dimensionName));
                continue;
            }
            if (dimensionName.equalsIgnoreCase(cube.getFactTable())) continue;
            throw new IllegalArgumentException("\u8be5dimension\u5e76\u6ca1\u6709\u5728cube\u4e2d\u5b9a\u4e49:" + dimensionName);
        }
        StringBuilder sb = new StringBuilder();
        for (Dimension dimension : dimensions) {
            sb.append(this.buildJoinStatementByDimension(cube.getFactTable(), dimension));
        }
        return sb.toString();
    }

    private String buildJoinStatementByDimension(String factTable, Dimension dimension) {
        StringBuilder sb = new StringBuilder();
        if (dimension.getTable().equalsIgnoreCase("date_dimension")) {
            sb.append(this.sqlBuilder.buildDateJoinStatement(factTable, dimension));
        } else {
            sb.append(this.sqlBuilder.buildNormalJoinStatement(factTable, dimension));
        }
        return sb.toString();
    }

    public String buildWhereStatement(Cube cube, String filter) {
        Dimension dimension;
        Pattern p = Pattern.compile("(\\w+):(\\w+)");
        Matcher m = p.matcher(filter);
        LinkedList<DimensionLevelNamePair> pairs = new LinkedList<DimensionLevelNamePair>();
        while (m.find()) {
            String dimensionName = m.group(1);
            String levelName = m.group(2);
            pairs.add(new DimensionLevelNamePair(dimensionName, levelName));
        }
        for (DimensionLevelNamePair pair : pairs) {
            dimension = cube.getDimension(pair.getDimensionName());
            if (dimension == null) {
                throw new IllegalArgumentException("\u8be5dimension\u5e76\u6ca1\u6709\u5728cube\u4e2d\u5b9a\u4e49:" + pair.getDimensionName());
            }
            Level level = dimension.getLevel(pair.getLevelName());
            if (level == null) {
                throw new IllegalArgumentException("\u8be5level:" + pair.getLevelName() + "\u5e76\u6ca1\u6709\u5728dimension:" + pair.getDimensionName() + "\u4e2d\u5b9a\u4e49");
            }
            filter = filter.replaceAll("(" + pair.getDimensionName() + "):" + pair.getLevelName(), "$1." + level.getKey());
        }
        for (String dimensionName : StringUtil.getMatchedGroups(filter, "(\\w+)[:\\.]")) {
            if (dimensionName.equals(cube.getFactTable())) continue;
            dimension = cube.getDimension(dimensionName);
            if (dimension == null) {
                throw new IllegalArgumentException("\u8be5dimension\u5e76\u6ca1\u6709\u5728cube\u4e2d\u5b9a\u4e49:" + dimensionName);
            }
            filter = filter.replaceAll(dimensionName + "([:\\.])", dimension.getTable() + "$1");
        }
        return " where " + filter;
    }

    public String buildGroupStatement(Cube cube, List<Level> levels) {
        StringBuilder sb = new StringBuilder(" group by ");
        LinkedList<String> groupBys = new LinkedList<String>();
        for (Level level : levels) {
            groupBys.add(level.getDimension().getTable() + "." + level.getKey());
        }
        return sb.append(StringUtils.join(groupBys, (String)",")).toString();
    }

    public String buildOrderStatement(Cube cube, List<Level> levels) {
        StringBuilder sb = new StringBuilder(" order by ");
        LinkedList<String> groupBys = new LinkedList<String>();
        for (Level level : levels) {
            groupBys.add(level.getDimension().getTable() + "." + level.getKey());
        }
        return sb.append(StringUtils.join(groupBys, (String)",")).toString();
    }

    public void setSqlBuilder(SqlBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    class DimensionLevelNamePair {
        private String dimensionName;
        private String levelName;

        public DimensionLevelNamePair(String dimensionName, String levelName) {
            this.dimensionName = dimensionName;
            this.levelName = levelName;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public String getLevelName() {
            return this.levelName;
        }
    }
}

