/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.olap;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Olap {
    private JdbcTemplate jdbcTemplate;
    private String[] operators = new String[]{"!=", "<>", "<", ">", "="};

    public List<Map<String, Object>> calOLAP(String tableName, String joinTable, String fact, String dimension, String filters, String orderBy) {
        String[] filterses = filters.split(" AND ");
        StringBuilder where = new StringBuilder(" WHERE ");
        for (int i = 0; i < filterses.length; ++i) {
            String filter = filterses[i];
            if (filter.toUpperCase().indexOf("IS NOT NULL") > -1 || filter.toUpperCase().indexOf("IS NULL") > -1) {
                where.append(this.tablePlusColumn(tableName, filter));
                continue;
            }
            String operator = "=";
            for (int index = 0; index < this.operators.length; ++index) {
                if (filter.indexOf(this.operators[index]) <= -1) continue;
                operator = this.operators[index];
                break;
            }
            String[] ws = filter.split(operator);
            if (i > 0) {
                where.append(" AND ");
            }
            String key = ws[0].trim();
            String value = ws[1].trim();
            if (key.indexOf(":") > -1) {
                key = this.getColumn(key, tableName);
                value = "'" + value + "'";
            }
            where.append(this.tablePlusColumn(tableName, key) + operator + value);
        }
        return this.exCalOLAP(tableName, joinTable, fact, dimension, where.toString(), orderBy);
    }

    private List<Map<String, Object>> exCalOLAP(String tableName, String joinTable, String fact, String dimension, String where, String orderBy) {
        String columns = fact;
        String groupBy = "";
        if (StringUtils.isNotBlank((CharSequence)dimension)) {
            String[] dimensions = dimension.split(",");
            StringBuilder dimenPlus = new StringBuilder("");
            for (String dss : dimensions) {
                if (dimenPlus.length() > 0) {
                    dimenPlus.append(", ");
                }
                String column = this.getColumn(dss, tableName);
                dimenPlus.append(column);
                columns = column + " AS " + dss.split(":")[0] + ", " + fact;
            }
            groupBy = " GROUP BY " + dimenPlus;
        }
        if (StringUtils.isNotBlank((CharSequence)orderBy)) {
            orderBy = " ORDER BY " + orderBy;
        }
        String sql = "SELECT " + columns + " FROM " + tableName + where + groupBy + orderBy;
        if (StringUtils.isNotBlank((CharSequence)joinTable)) {
            String[] joinTableNames;
            StringBuilder join = new StringBuilder("");
            String[] arr$ = joinTableNames = joinTable.split("\\+");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String joinTableName;
                String joinName = joinTableName = arr$[i$];
                String joinTablePrimary = "id";
                String tableForeign = joinName + "_" + "id";
                if (joinTableName.indexOf("[") > -1 && joinTableName.indexOf("]") > -1) {
                    joinName = joinTableName.substring(0, joinTableName.indexOf("["));
                    String priFor = joinTableName.substring(joinTableName.indexOf("[") + 1, joinTableName.indexOf("]"));
                    tableForeign = priFor.split(",")[0];
                    if (priFor.split(",").length == 2) {
                        joinTablePrimary = priFor.split(",")[1];
                    }
                }
                join.append(" LEFT JOIN " + joinName);
                join.append(" ON " + joinName + "." + joinTablePrimary + "=" + this.tablePlusColumn(tableName, tableForeign));
            }
            sql = "SELECT " + columns + " FROM " + tableName + join + where + groupBy + orderBy;
        }
        return this.jdbcTemplate.queryForList(sql);
    }

    private String tablePlusColumn(String tableName, String columnName) {
        String tablePlusColumn = columnName;
        if (columnName.indexOf(".") == -1) {
            tablePlusColumn = tableName + "." + columnName;
        }
        return tablePlusColumn;
    }

    private String getColumn(String key, String tableName) {
        if (key.indexOf(":") > -1) {
            String column = key.split(":")[0].trim();
            String format = key.split(":")[1].trim();
            if (format.equals("year")) {
                format = "yyyy";
            } else if (format.equals("month")) {
                format = "yyyy-mm";
            } else if (format.equals("day")) {
                format = "yyyy-mm-dd";
            }
            return "to_char(" + this.tablePlusColumn(tableName, column) + ", '" + format + "')";
        }
        return this.tablePlusColumn(tableName, key);
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }
}

