/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.olap;

import com.zainta.olap.Aggregate;

public class Fact {
    private String factName;
    private String calculation;
    private String filter;
    private Aggregate aggregate;
    private String factField;
    private static final String REGEX_NORMAL_FACT = "(?i)^(count|sum|avg|max|min)\\([\\w\\.]+\\)$";
    private static final String REGEX_COMPUTED_FACT = "\\(*\\w+\\)*(\\s*[\\+\\-\\*/]\\s*\\(*\\w+\\)*)+";

    public Fact(String factName, String calculation, String filter) {
        this.factName = factName;
        this.calculation = calculation;
        this.filter = filter;
        if (!calculation.matches(REGEX_NORMAL_FACT) && !this.isComputed()) {
            throw new IllegalArgumentException("\u8f93\u5165\u7684calculation\u4e0d\u7b26\u5408\u683c\u5f0f");
        }
        if (this.isComputed()) {
            return;
        }
        String aggregateKeyWord = this.calculation.substring(0, this.calculation.indexOf("("));
        if (Aggregate.COUNT.isMatched(aggregateKeyWord)) {
            this.aggregate = Aggregate.COUNT;
        } else if (Aggregate.SUM.isMatched(aggregateKeyWord)) {
            this.aggregate = Aggregate.SUM;
        } else if (Aggregate.AVG.isMatched(aggregateKeyWord)) {
            this.aggregate = Aggregate.AVG;
        } else if (Aggregate.MAX.isMatched(aggregateKeyWord)) {
            this.aggregate = Aggregate.MAX;
        } else if (Aggregate.MIN.isMatched(aggregateKeyWord)) {
            this.aggregate = Aggregate.MIN;
        }
        this.factField = this.calculation.substring(this.calculation.indexOf("(") + 1, this.calculation.indexOf(")"));
    }

    public String getFactName() {
        return this.factName;
    }

    public void setFactName(String factName) {
        this.factName = factName;
    }

    public String getCalculation() {
        return this.calculation;
    }

    public void setCalculation(String calculation) {
        this.calculation = calculation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.factName == null ? 0 : this.factName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Fact other = (Fact)obj;
        return !(this.factName == null ? other.factName != null : !this.factName.equals(other.factName));
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Aggregate getAggregate() {
        return this.aggregate;
    }

    public String getFactField() {
        return this.factField;
    }

    public boolean isComputed() {
        return this.getCalculation().matches(REGEX_COMPUTED_FACT);
    }
}

