/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.olap;

import com.zainta.olap.Level;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dimension {
    private String dimensionName;
    private String table;
    private String key;
    private String foreignKey;
    private boolean isRight;
    private List<Level> levels;

    public Dimension(String dimensionName, String table, String key, String foreignKey) {
        this.dimensionName = dimensionName;
        this.table = table;
        this.key = key;
        this.foreignKey = foreignKey;
        this.levels = new ArrayList<Level>();
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public String getTable() {
        return this.table;
    }

    public String getKey() {
        return this.key;
    }

    public String getForeignKey() {
        return this.foreignKey;
    }

    public List<Level> getLevels() {
        return this.levels;
    }

    public void setLevels(List<Level> levels) {
        for (Level level : levels) {
            level.setDimension(this);
        }
        this.levels = levels;
        this.sortLevels();
    }

    public void addLevel(Level level) {
        level.setDimension(this);
        this.levels.add(level);
        this.sortLevels();
    }

    private void sortLevels() {
        Collections.sort(this.levels, new Comparator<Level>(){

            @Override
            public int compare(Level level1, Level level2) {
                return level1.getOrder().compareTo(level2.getOrder());
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimensionName == null ? 0 : this.dimensionName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dimension other = (Dimension)obj;
        return !(this.dimensionName == null ? other.dimensionName != null : !this.dimensionName.equals(other.dimensionName));
    }

    public Level getLevel(String levelName) {
        for (Level level : this.getLevels()) {
            if (!level.getName().equals(levelName)) continue;
            return level;
        }
        return null;
    }

    public boolean isRight() {
        return this.isRight;
    }

    public void setRight(boolean isRight) {
        this.isRight = isRight;
    }
}

