/*
 * Decompiled with CFR 0.152.
 */
package com.zainta.olap;

import com.zainta.olap.Dimension;
import com.zainta.olap.Fact;
import com.zainta.olap.Level;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.CaseInsensitiveMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cube {
    private String factTable;
    private Map<String, Fact> factsMap = new CaseInsensitiveMap();
    private Map<String, Dimension> dimensionsMap = new HashMap<String, Dimension>();
    private String filter;
    private static final String ELEMENT_SEPARATOR = ",";
    private static final String LEVEL_SEPARATOR = ":";

    public Cube() {
    }

    public Cube(String factTable) {
        this.factTable = factTable;
    }

    public String getFactTable() {
        return this.factTable;
    }

    public void setFactTable(String factTable) {
        this.factTable = factTable;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void addFact(Fact fact) {
        this.factsMap.put(fact.getFactName(), fact);
    }

    public Fact getFact(String factName) {
        return this.factsMap.get(factName);
    }

    public void addDimension(Dimension dimension) {
        this.dimensionsMap.put(dimension.getDimensionName(), dimension);
    }

    public Dimension getDimension(String dimensionName) {
        return this.dimensionsMap.get(dimensionName);
    }

    public Set<Fact> getFactsFromFactNameString(String factsString) {
        String[] factStrings = factsString.split(ELEMENT_SEPARATOR);
        HashSet<Fact> facts = new HashSet<Fact>();
        for (String factString : factStrings) {
            Fact fact = this.getFact(factString.trim());
            if (fact == null) continue;
            facts.add(fact);
        }
        return facts;
    }

    public List<Level> getLevelsFromDimensionString(String dimensionsString) {
        String[] dimensionStrings = dimensionsString.split(ELEMENT_SEPARATOR);
        LinkedList<Level> levels = new LinkedList<Level>();
        block0: for (String dimensionString : dimensionStrings) {
            String[] dimenLevelPair = dimensionString.trim().split(LEVEL_SEPARATOR);
            Dimension dimension = null;
            if (dimenLevelPair.length > 0 && (dimension = this.getDimension(dimenLevelPair[0].trim())) == null) continue;
            if (dimenLevelPair.length == 2) {
                for (Level level : dimension.getLevels()) {
                    if (!level.getName().equals(dimenLevelPair[1].trim())) continue;
                    levels.add(level);
                    continue block0;
                }
                continue;
            }
            if (dimenLevelPair.length != 1 || dimension.getLevels().size() <= 0) continue;
            levels.add(dimension.getLevels().get(0));
        }
        return levels;
    }
}

