/*
 * Decompiled with CFR 0.152.
 */
package com.demo2do.lighturl.result.impl;

import com.demo2do.lighturl.result.ResultCodeConfig;
import com.demo2do.lighturl.result.ResultCodeUtils;
import com.demo2do.lighturl.result.impl.AbstractResultCodeConfig;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamResultCodeConfig
extends AbstractResultCodeConfig
implements ResultCodeConfig {
    protected ResultTypeConfig streamResultTypeConfig;

    @Override
    public void initResultType() {
        this.streamResultTypeConfig = this.results.get("stream");
    }

    @Override
    public boolean isMatchedResult(String resultCode) {
        return ResultCodeUtils.isStreamResult(resultCode);
    }

    @Override
    public ResultConfig build(ActionContext actionContext, String actionName, ActionConfig actionConfig, String resultCode) {
        Map<String, String> params = this.prepareParams(actionContext, actionName, actionConfig, resultCode);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.streamResultTypeConfig.addParam(entry.getKey(), entry.getValue());
        }
        return super.buildResultConfig("", resultCode, this.streamResultTypeConfig);
    }

    protected Map<String, String> prepareParams(ActionContext actionContext, String actionName, ActionConfig actionConfig, String resultCode) {
        List<String> supportedParams = Arrays.asList("inputName", "contentType", "contentDisposition", "contentLength", "bufferSize");
        String[] resultParams = StringUtils.split((String)ResultCodeUtils.parseResultCode(resultCode), (String)"|");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (int i = 0; i < supportedParams.size(); ++i) {
            if (i >= resultParams.length) continue;
            params.put(supportedParams.get(i), resultParams[i]);
        }
        return params;
    }
}

