/*
 * Decompiled with CFR 0.152.
 */
package com.demo2do.lighturl.result.impl;

import com.demo2do.lighturl.result.ResultCodeConfig;
import com.demo2do.lighturl.result.impl.AbstractResultCodeConfig;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.inject.Inject;
import java.net.MalformedURLException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.util.ClassLoaderUtils;

public class DispatcherResultCodeConfig
extends AbstractResultCodeConfig
implements ResultCodeConfig {
    private static final Log logger = LogFactory.getLog(DispatcherResultCodeConfig.class);
    @Inject
    protected ServletContext servletContext;
    protected String baseResultLocation = "/";
    protected Map<String, ResultTypeConfig> dispatchResults = new LinkedHashMap<String, ResultTypeConfig>();

    public void initResultType() {
        this.dispatchResults.put("jsp", this.results.get("dispatcher"));
        this.dispatchResults.put("ftl", this.results.get("freemarker"));
        this.dispatchResults.put("vm", this.results.get("velocity"));
    }

    public boolean isMatchedResult(String resultCode) {
        return !resultCode.contains(":");
    }

    public ResultConfig build(ActionContext actionContext, String actionName, ActionConfig actionConfig, String resultCode) {
        String actionClassName;
        String namespace = super.getNamespace(actionContext, actionName);
        String pathPrefix = this.determinePath(namespace);
        ResultConfig resultConfig = this.doBuild(pathPrefix, namespace, actionClassName = super.getActionName(actionConfig.getClassName()), resultCode);
        if (resultConfig == null && !"/".equals(namespace)) {
            String lastNamespacePackage = namespace.substring(namespace.lastIndexOf("/") + 1);
            pathPrefix = pathPrefix + lastNamespacePackage + "-";
            resultConfig = this.doBuild(pathPrefix, namespace, actionClassName, resultCode);
        }
        return resultConfig;
    }

    protected String determinePath(String namespace) {
        String finalPrefix = this.baseResultLocation;
        if (!finalPrefix.endsWith("/")) {
            finalPrefix = finalPrefix + "/";
        }
        if (namespace == null || "/".equals(namespace)) {
            namespace = "";
        }
        if (namespace.length() > 0) {
            if (namespace.startsWith("/")) {
                namespace = namespace.substring(1);
            }
            if (!namespace.endsWith("/")) {
                namespace = namespace + "/";
            }
        }
        return finalPrefix + namespace;
    }

    protected ResultConfig doBuild(String pathPrefix, String namespace, String actionName, String resultCode) {
        ResultConfig resultConfig = null;
        for (String ext : this.dispatchResults.keySet()) {
            String path;
            if (logger.isDebugEnabled()) {
                String action = namespace + "/" + actionName;
                logger.debug((Object)("Trying to locate result for action [" + action + "] with an file extension of [" + ext + "] in the directory [" + pathPrefix + "] " + "and a result code of [" + resultCode + "]"));
            }
            if ((resultConfig = this.buildPathBasedResultConfig(path = this.connect(pathPrefix, actionName, "-", resultCode, ".", ext), resultCode, this.dispatchResults.get(ext))) != null) {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Find Resource [" + actionName + "-" + resultCode + "." + ext + "] in the directory [" + pathPrefix + "] "));
                break;
            }
            path = this.connect(pathPrefix, resultCode, ".", ext);
            resultConfig = this.buildPathBasedResultConfig(path, resultCode, this.dispatchResults.get(ext));
            if (resultConfig != null) {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Find Resource [" + resultCode + "." + ext + "] in the directory [" + pathPrefix + "] "));
                break;
            }
            path = this.connect(pathPrefix, actionName, ".", ext);
            resultConfig = this.buildPathBasedResultConfig(path, resultCode, this.dispatchResults.get(ext));
            if (resultConfig == null) continue;
            if (!logger.isDebugEnabled()) break;
            logger.debug((Object)("Find Resource [" + actionName + "." + ext + "] in the directory [" + pathPrefix + "] "));
            break;
        }
        return resultConfig;
    }

    protected ResultConfig buildPathBasedResultConfig(String path, String resultCode, ResultTypeConfig config) {
        try {
            String classLoaderPath;
            if (this.servletContext.getResource(path) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found Resource:" + path));
                }
                return this.buildResultConfig(path, resultCode, config);
            }
            String string = classLoaderPath = path.startsWith("/") ? path.substring(1, path.length()) : path;
            if (ClassLoaderUtils.getResource((String)classLoaderPath, this.getClass()) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found Resource:" + path));
                }
                return this.buildResultConfig(path, resultCode, config);
            }
        }
        catch (MalformedURLException e) {
            logger.warn((Object)("Unable to parse template path: " + path + ", skipping..."));
        }
        return null;
    }

    private String connect(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(part);
        }
        return sb.toString();
    }
}

