/*
 * Decompiled with CFR 0.152.
 */
package com.demo2do.lighturl.result.impl;

import com.demo2do.lighturl.config.ActionUrlBuilder;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.inject.Inject;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultCodeConfig {
    protected Configuration configuration;
    protected PackageConfig parentPackage;
    protected ActionUrlBuilder actionUrlBuilder;
    protected Map<String, ResultTypeConfig> results;
    protected String[] actionPackages;

    public abstract void initResultType();

    @Inject
    public void init(@Inject Configuration configuration, @Inject ActionUrlBuilder actionUrlBuilder, @Inject(value="lighturl.action.default.parent.package") String defaultParentPackage, @Inject(value="lighturl.action.packages") String actionPackages) {
        this.configuration = configuration;
        this.parentPackage = configuration.getPackageConfig(defaultParentPackage);
        if (this.parentPackage == null) {
            throw new ConfigurationException("Unknown default parent package [" + defaultParentPackage + "]");
        }
        this.actionUrlBuilder = actionUrlBuilder;
        this.results = this.parentPackage.getAllResultTypeConfigs();
        this.actionPackages = actionPackages.split("\\s*[,]\\s*");
        this.initResultType();
    }

    public String getNamespace(ActionContext actionContext, String actionName) {
        String action = actionContext.getActionInvocation().getAction().getClass().getName();
        for (String actionPackage : this.actionPackages) {
            if (!action.startsWith(actionPackage)) continue;
            int begin = actionPackage.length();
            int end = action.lastIndexOf(".");
            return action.substring(begin, end).replaceAll("[.]", "/");
        }
        return null;
    }

    protected String getActionName(String actionClassName) {
        int lastDotIndex = actionClassName.lastIndexOf(".");
        return this.actionUrlBuilder.build(actionClassName.substring(lastDotIndex + 1));
    }

    protected ResultConfig buildResultConfig(String path, String resultCode, ResultTypeConfig config) {
        String resultClass = config.getClazz();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (config.getParams() != null) {
            params.putAll(config.getParams());
        }
        if (config.getDefaultResultParam() != null && StringUtils.isNotEmpty((String)path)) {
            params.put(config.getDefaultResultParam(), path);
        }
        return new ResultConfig(resultCode, resultClass, params);
    }

    protected ResultConfig buildResultConfig(String path, String resultCode, ResultTypeConfig config, Map<String, String> params) {
        String resultClass = config.getClazz();
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (config.getParams() != null) {
            parameters.putAll(config.getParams());
        }
        if (config.getDefaultResultParam() != null) {
            parameters.put(config.getDefaultResultParam(), path);
        }
        parameters.putAll(params);
        return new ResultConfig(resultCode, resultClass, parameters);
    }
}

