/*
 * Decompiled with CFR 0.152.
 */
package com.demo2do.lighturl.result;

import com.demo2do.lighturl.result.ResultBuilder;
import com.demo2do.lighturl.result.ResultCodeConfig;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightURLResultBuilder
implements ResultBuilder {
    private static final Log logger = LogFactory.getLog(LightURLResultBuilder.class);
    @Inject
    protected ObjectFactory objectFactory;
    @Inject(value="dispatcher")
    protected ResultCodeConfig dispatcherResultCodeConfig;
    @Inject(value="redirect")
    protected ResultCodeConfig redirectResultCodeConfig;
    @Inject(value="json")
    protected ResultCodeConfig jsonResultCodeConfig;
    @Inject(value="chain")
    protected ResultCodeConfig actionChainResultCodeConfig;
    @Inject(value="stream")
    protected ResultCodeConfig streamChainResultCodeConfig;
    @Inject(value="text-string")
    protected ResultCodeConfig textStringChainResultCodeConfig;
    protected List<ResultCodeConfig> customizedResultCodeConfigs = new ArrayList<ResultCodeConfig>();

    @Inject(required=false, value="lighturl.result.code.configs")
    public void registerCustomizedResultCodeConfig(String configs) {
        String[] classes;
        for (String className : classes = configs.split("\\s*[,]\\s*")) {
            try {
                ResultCodeConfig resultCodeConfig = (ResultCodeConfig)this.objectFactory.buildBean(className, null);
                this.customizedResultCodeConfigs.add(resultCodeConfig);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to instantiate ResultCodeConfig: " + className, (Throwable)e);
            }
        }
    }

    @Override
    public ResultConfig build(ActionContext actionContext, String actionName, ActionConfig actionConfig, String resultCode) {
        ResultConfig resultConfig = null;
        List<ResultCodeConfig> configs = this.setupResultCodeConfigs();
        for (ResultCodeConfig config : configs) {
            if (config.isMatchedResult(resultCode) && (resultConfig = config.build(actionContext, actionName, actionConfig, resultCode)) != null) break;
        }
        return resultConfig;
    }

    protected List<ResultCodeConfig> setupResultCodeConfigs() {
        ArrayList<ResultCodeConfig> configs = new ArrayList<ResultCodeConfig>();
        configs.add(this.dispatcherResultCodeConfig);
        if (!this.customizedResultCodeConfigs.isEmpty()) {
            configs.addAll(this.customizedResultCodeConfigs);
        }
        configs.add(this.actionChainResultCodeConfig);
        configs.add(this.streamChainResultCodeConfig);
        configs.add(this.textStringChainResultCodeConfig);
        configs.add(this.jsonResultCodeConfig);
        configs.add(this.redirectResultCodeConfig);
        return configs;
    }
}

