/*
 * Decompiled with CFR 0.152.
 */
package com.demo2do.lighturl.mapping.impl;

import com.demo2do.lighturl.mapping.ActionConfigMapping;
import com.demo2do.lighturl.mapping.ActionMappingBuilder;
import com.demo2do.lighturl.mapping.ActionMappingHandler;
import com.demo2do.lighturl.mapping.Url;
import com.opensymphony.xwork2.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.mapper.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightURLActionMappingBuilder
implements ActionMappingBuilder {
    private static final Log logger = LogFactory.getLog(LightURLActionMappingBuilder.class);
    @Inject(value="namespace")
    private ActionMappingHandler namespaceNamingActionMappingHandler;
    @Inject(value="full")
    private ActionMappingHandler fullNamingActionMappingHandler;
    @Inject(value="package")
    private ActionMappingHandler packageNamingActionMappingHandler;
    @Inject(value="view")
    private ActionMappingHandler viewNamingActionMappingHandler;
    @Inject(value="ant-path")
    private ActionMappingHandler antPathNamingActionMappingHandler;
    @Inject(value="url-template")
    private ActionMappingHandler urlTemplateNamingActionMappingHandler;

    @Override
    public ActionMapping build(String requestURI, ActionConfigMapping actionConfigMapping) {
        ActionMapping actionMapping = null;
        List<ActionMappingHandler> handlers = this.setupActionMappingHandlers();
        for (Url url : Url.values()) {
            Map<String, ActionMapping> mappings;
            ActionMappingHandler handler = handlers.get(url.ordinal());
            if (!handler.match(requestURI, mappings = actionConfigMapping.getActionMappings(url)) || (actionMapping = handler.get(requestURI, mappings)) == null) continue;
            logger.info((Object)("Successfully find actionMapping: [ namespace: " + actionMapping.getNamespace() + ", actionName: " + actionMapping.getName() + ", method: " + actionMapping.getMethod() + ", params: " + actionMapping.getParams() + " ] for requestURI: " + requestURI));
            return actionMapping;
        }
        return actionMapping;
    }

    @Override
    public ActionMappingHandler getHandler(Url url) {
        List<ActionMappingHandler> handlers = this.setupActionMappingHandlers();
        return handlers.get(url.ordinal());
    }

    protected List<ActionMappingHandler> setupActionMappingHandlers() {
        ArrayList<ActionMappingHandler> handlers = new ArrayList<ActionMappingHandler>();
        handlers.add(this.namespaceNamingActionMappingHandler);
        handlers.add(this.fullNamingActionMappingHandler);
        handlers.add(this.packageNamingActionMappingHandler);
        handlers.add(this.viewNamingActionMappingHandler);
        handlers.add(this.antPathNamingActionMappingHandler);
        handlers.add(this.urlTemplateNamingActionMappingHandler);
        return handlers;
    }
}

