/*
 * Decompiled with CFR 0.152.
 */
package com.demo2do.lighturl.mapping;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlTemplate {
    private String urlTemplate;
    private String template;
    private String[] parts;
    private Map<String, String> params = new HashMap<String, String>();

    public UrlTemplate(String urlTemplate) {
        int begin = urlTemplate.startsWith("/") ? 1 : 0;
        int end = urlTemplate.endsWith("/") ? urlTemplate.length() - 1 : urlTemplate.length();
        String[] temps = StringUtils.split((String)urlTemplate.substring(begin, end), (String)"/");
        StringBuffer sb = new StringBuffer();
        for (String temp : temps) {
            sb.append("/");
            if (temp.contains("${")) {
                sb.append("[^\\s^/]+");
                continue;
            }
            sb.append(temp);
        }
        this.urlTemplate = urlTemplate;
        this.template = sb.toString();
        this.parts = temps;
    }

    public UrlTemplate(String urlTemplate, String url) {
        int beginTemplate = urlTemplate.startsWith("/") ? 1 : 0;
        int endTemplate = urlTemplate.endsWith("/") ? urlTemplate.length() - 1 : urlTemplate.length();
        String[] tempTemplates = StringUtils.split((String)urlTemplate.substring(beginTemplate, endTemplate), (String)"/");
        int begin = url.startsWith("/") ? 1 : 0;
        int end = url.endsWith("/") ? url.length() - 1 : url.length();
        String[] temps = StringUtils.split((String)url.substring(begin, end), (String)"/");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tempTemplates.length; ++i) {
            sb.append("/");
            if (tempTemplates[i].contains("${")) {
                sb.append("[^\\s^/]+");
                String key = tempTemplates[i].substring(2, tempTemplates[i].length() - 1);
                this.params.put(key, temps[i]);
                continue;
            }
            sb.append(tempTemplates[i]);
        }
        this.urlTemplate = urlTemplate;
        this.template = sb.toString();
        this.parts = temps;
    }

    public boolean match(String urlTemplate) {
        int end;
        int begin = urlTemplate.startsWith("/") ? 1 : 0;
        String[] temps = StringUtils.split((String)urlTemplate.substring(begin, end = urlTemplate.endsWith("/") ? urlTemplate.length() - 1 : urlTemplate.length()), (String)"/");
        if (temps.length != this.parts.length) {
            return false;
        }
        for (int i = 0; i < temps.length; ++i) {
            if (temps[i].startsWith("${") || this.parts[i].startsWith("${") || temps[i].equals(this.parts[i])) continue;
            return false;
        }
        return true;
    }

    public String get() {
        return this.urlTemplate;
    }

    public String[] getParts() {
        return this.parts;
    }

    public String getTemplate() {
        return this.template;
    }

    public Map<String, String> getParams() {
        return this.params;
    }
}

