/*
 * Decompiled with CFR 0.152.
 */
package com.demo2do.lighturl.mapping;

import com.demo2do.lighturl.mapping.Url;
import com.demo2do.lighturl.mapping.UrlMatcher;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.mapper.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionConfigMapping {
    private static final Log logger = LogFactory.getLog(ActionConfigMapping.class);
    private Map<Url, Map<String, ActionMapping>> actionMappings = new HashMap<Url, Map<String, ActionMapping>>();

    public ActionConfigMapping() {
        for (Url url : Url.values()) {
            this.actionMappings.put(url, new LinkedHashMap());
        }
    }

    public Map<String, ActionMapping> getActionMappings(Url url) {
        return this.actionMappings.get((Object)url);
    }

    public Set<String> getFullMatchedKeys() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.actionMappings.get((Object)Url.NAMESPACE_NAMING).keySet());
        keys.addAll(this.actionMappings.get((Object)Url.PACKAGE_NAMING).keySet());
        keys.addAll(this.actionMappings.get((Object)Url.FULL_NAMING).keySet());
        return keys;
    }

    public Set<String> getConvertedViewNamingKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (String key : this.actionMappings.get((Object)Url.VIEW_NAMING).keySet()) {
            keys.add(key.substring(0, key.lastIndexOf("/") + 1) + "[^\\s^/]+");
        }
        return keys;
    }

    public boolean put(Url url, String key, ActionMapping actionMapping) {
        Map<String, ActionMapping> mappings = this.actionMappings.get((Object)url);
        if (mappings.containsKey(key)) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating " + (Object)((Object)url) + " ActionConfigMapping with key [" + key + "], namespace [" + actionMapping.getNamespace() + "] and actionName [" + actionMapping.getName() + "]"));
        }
        mappings.put(key, actionMapping);
        return true;
    }

    public boolean isNamespaceNaming(Url url, String key) {
        if (url == Url.FULL_NAMING) {
            return this.actionMappings.get((Object)Url.NAMESPACE_NAMING).containsKey(key);
        }
        if (url == Url.ANTPATH_NAMING) {
            for (String namespaceNamingKey : this.actionMappings.get((Object)Url.NAMESPACE_NAMING).keySet()) {
                if (!UrlMatcher.match(key, namespaceNamingKey)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPackageNaming(Url url, String key) {
        if (url == Url.FULL_NAMING) {
            return this.actionMappings.get((Object)Url.PACKAGE_NAMING).containsKey(key);
        }
        if (url == Url.ANTPATH_NAMING) {
            for (String namespaceNamingKey : this.actionMappings.get((Object)Url.PACKAGE_NAMING).keySet()) {
                if (!UrlMatcher.match(key, namespaceNamingKey)) continue;
                return true;
            }
        }
        return false;
    }
}

