/*
 * Decompiled with CFR 0.152.
 */
package com.demo2do.lighturl.mapping;

import com.demo2do.lighturl.mapping.Url;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionConfigContainer {
    private static final Log logger = LogFactory.getLog(ActionConfigContainer.class);
    private Url url;
    private String namespace;
    private String actionName;
    private ActionConfig actionConfig;

    public ActionConfigContainer(Url url, String namespace, String actionName, ActionConfig actionConfig) {
        this.url = url;
        this.namespace = namespace;
        this.actionName = actionName;
        this.actionConfig = actionConfig;
    }

    public ActionConfigContainer(Url url, String actionClass, String packageName, String namespace, String actionName, String methodName) {
        this.url = url;
        this.namespace = namespace;
        this.actionName = actionName;
        this.actionConfig = this.createActionConfig(actionClass, packageName, namespace, actionName, methodName);
    }

    protected ActionConfig createActionConfig(String actionClass, String packageName, String namespace, String actionName, String methodName) {
        ActionConfig actionConfig = new ActionConfig();
        actionConfig.setClassName(actionClass);
        actionConfig.setPackageName(packageName);
        if (StringUtils.isEmpty((String)methodName)) {
            actionConfig.setMethodName("execute");
        } else {
            actionConfig.setMethodName(methodName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating action config for class [" + actionClass + "], name [" + actionName + "] " + "and package name [" + packageName + "] in namespace [" + namespace + "]"));
        }
        return actionConfig;
    }

    public Url getUrl() {
        return this.url;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getActionName() {
        return this.actionName;
    }

    public ActionConfig getActionConfig() {
        return this.actionConfig;
    }
}

