/*
 * Decompiled with CFR 0.152.
 */
package com.demo2do.lighturl.config.impl;

import com.demo2do.lighturl.config.ActionNameUnknownHandler;
import com.demo2do.lighturl.config.ActionUrlBuilder;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ResolverUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultViewActionNameHandler
implements ActionNameUnknownHandler {
    private static final Log logger = LogFactory.getLog(DefaultViewActionNameHandler.class);
    @Inject(value="lighturl.entity.package", required=false)
    private String entityPackage;
    @Inject
    private ActionUrlBuilder actionUrlBuilder;

    @Override
    public List<String> buildAlias(Class<?> actionClass, String namespace) {
        ArrayList<String> result = new ArrayList<String>();
        if (actionClass.getName().endsWith(".View")) {
            if (this.entityPackage != null && StringUtils.countMatches((String)namespace, (String)"/") == 1 && !namespace.equals("/")) {
                List<String> entities = this.getEntityAlias();
                if (entities.contains(namespace.substring(1))) {
                    result.add(namespace.substring(1) + "-view");
                }
            } else {
                result.add("view");
            }
        }
        return result;
    }

    protected List<String> getEntityAlias() {
        ArrayList<String> entities = new ArrayList<String>();
        ResolverUtil resolver = new ResolverUtil();
        resolver.find(new ResolverUtil.Test(){

            public boolean matches(Class type) {
                return true;
            }
        }, new String[]{this.entityPackage});
        Set entityClasses = resolver.getClasses();
        for (Class entityClass : entityClasses) {
            String entityClassName = entityClass.getName().substring(entityClass.getName().lastIndexOf(".") + 1);
            entities.add(this.actionUrlBuilder.build(entityClassName));
        }
        return entities;
    }
}

