/*
 * Decompiled with CFR 0.152.
 */
package com.demo2do.lighturl.config.impl;

import com.demo2do.lighturl.annotation.Actions;
import com.demo2do.lighturl.annotation.ParentPackage;
import com.demo2do.lighturl.config.ActionConfigBuilder;
import com.demo2do.lighturl.config.ActionNameUnknownHandler;
import com.demo2do.lighturl.config.ActionUrlBuilder;
import com.demo2do.lighturl.mapping.ActionConfigContainer;
import com.demo2do.lighturl.mapping.ActionConfigMapping;
import com.demo2do.lighturl.mapping.ActionMappingBuilder;
import com.demo2do.lighturl.mapping.ActionMappingHandler;
import com.demo2do.lighturl.mapping.Url;
import com.demo2do.lighturl.mapping.UrlMatcher;
import com.demo2do.lighturl.mapping.UrlTemplate;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ResolverUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.mapper.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultActionConfigBuilder
implements ActionConfigBuilder {
    private static final Log logger = LogFactory.getLog(DefaultActionConfigBuilder.class);
    @Inject
    private Configuration configuration;
    @Inject
    private ObjectFactory objectFactory;
    @Inject
    private ServletContext servletContext;
    @Inject
    private ActionUrlBuilder actionUrlBuilder;
    private ActionNameUnknownHandler actionNameUnknownHandler;
    @Inject(value="view")
    private ActionNameUnknownHandler viewActionNameHandler;
    @Inject
    private ActionMappingBuilder actionMappingBuilder;
    private boolean viewActionMapping = true;
    private String defaultParentPackage = "struts-default";

    @Inject(value="lighturl.action.default.parent.package", required=false)
    public void setDefaultParentPackage(String defaultParentPackage) {
        this.defaultParentPackage = defaultParentPackage;
    }

    @Inject(required=false)
    public void setActionNameUnknownHandler(ActionNameUnknownHandler actionNameUnknownHandler) {
        this.actionNameUnknownHandler = actionNameUnknownHandler;
    }

    @Inject(value="lighturl.config.view.action.handle", required=false)
    public void setViewActionMapping(boolean viewActionMapping) {
        this.viewActionMapping = viewActionMapping;
    }

    @Override
    public void buildActionConfigs(String ... actionPackages) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Loading action configurations from action packages " + Arrays.asList(actionPackages)));
        }
        LinkedHashMap<String, PackageConfig> packageConfigs = new LinkedHashMap<String, PackageConfig>();
        Map<String, Set<Class<?>>> actionMapper = this.getPackageBasedActionMapper(actionPackages);
        Map<Url, Set<ActionConfigContainer>> actionConfigContainers = this.createActionConfigContainers();
        for (String actionClassNamespace : actionMapper.keySet()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Processing all the action classes under package [" + actionClassNamespace + "]"));
            }
            for (Class<?> actionClass : actionMapper.get(actionClassNamespace)) {
                PackageConfig packageConfig = this.buildPackageConfig(packageConfigs, actionClass, actionClassNamespace);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Processing class [" + actionClass.getName() + "] in package [" + actionClassNamespace + "]"));
                }
                try {
                    this.objectFactory.getClassInstance(actionClass.getName());
                }
                catch (ClassNotFoundException e) {
                    new Throwable().printStackTrace();
                    System.exit(1);
                }
                String actionName = this.getActionName(actionClass);
                ActionConfigContainer packageNamingActionConfigContainer = this.createPackageNamingActionConfigContainer(packageConfig, actionClass.getName(), actionName, actionConfigContainers);
                this.createNamespaceNamingActionConfigContainer(packageConfig, actionName, packageNamingActionConfigContainer, actionConfigContainers);
                this.createAliasNamingActionConfigContainer(packageConfig, actionClass, actionClassNamespace, actionConfigContainers);
                this.createAnnotationNamingActionConfigContainers(packageConfig, actionClass, actionConfigContainers);
            }
        }
        this.addToRuntimeConfiguration(packageConfigs);
        this.addActionConfigContainersToActionConfigMapping(actionConfigContainers);
    }

    protected Map<String, Set<Class<?>>> getPackageBasedActionMapper(String ... actionPackages) {
        HashMap packageBasedActionMapper = new HashMap();
        ResolverUtil resolver = new ResolverUtil();
        resolver.find(new ResolverUtil.Test(){

            public boolean matches(Class type) {
                return Action.class.isAssignableFrom(type) || type.getSimpleName().endsWith("Action");
            }
        }, actionPackages);
        for (Class actionClass : resolver.getClasses()) {
            String actionClassPackage = this.getNamespace(actionClass.getPackage().getName(), actionPackages);
            if (packageBasedActionMapper.containsKey(actionClassPackage)) {
                ((Set)packageBasedActionMapper.get(actionClassPackage)).add(actionClass);
                continue;
            }
            HashSet<Class> classes = new HashSet<Class>();
            classes.add(actionClass);
            packageBasedActionMapper.put(actionClassPackage, classes);
        }
        return packageBasedActionMapper;
    }

    protected PackageConfig buildPackageConfig(Map<String, PackageConfig> packageConfigs, Class<?> actionClass, String actionClassPackage) {
        String actionPackage = actionClass.getPackage().getName();
        ParentPackage parent = actionClass.getAnnotation(ParentPackage.class);
        String parentName = parent == null ? this.defaultParentPackage : parent.value();
        PackageConfig parentPackage = this.configuration.getPackageConfig(parentName);
        if (parentPackage == null) {
            throw new ConfigurationException("Unable to locate parent package [" + parentName + "]");
        }
        String name = actionPackage + "#" + parentPackage.getName() + "#" + actionClassPackage;
        PackageConfig packageConfig = packageConfigs.get(name);
        if (packageConfig == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created package config named [" + name + "] with a namespace [" + actionClassPackage + "]"));
            }
            packageConfig = new PackageConfig();
            packageConfig.setName(name);
            packageConfig.setNamespace(actionClassPackage);
            packageConfig.addParent(parentPackage);
            packageConfigs.put(name, packageConfig);
        }
        return packageConfig;
    }

    protected ActionConfigContainer createPackageNamingActionConfigContainer(PackageConfig packageConfig, String namespace, String actionName, Map<Url, Set<ActionConfigContainer>> actionConfigContainers) {
        ActionConfigContainer packageNamingActionConfigContainer = new ActionConfigContainer(Url.PACKAGE_NAMING, namespace, packageConfig.getName(), packageConfig.getNamespace(), actionName, null);
        packageConfig.addActionConfig(actionName, packageNamingActionConfigContainer.getActionConfig());
        actionConfigContainers.get((Object)Url.PACKAGE_NAMING).add(packageNamingActionConfigContainer);
        return packageNamingActionConfigContainer;
    }

    protected void createNamespaceNamingActionConfigContainer(PackageConfig packageConfig, String actionName, ActionConfigContainer packageNamingActionConfigContainer, Map<Url, Set<ActionConfigContainer>> actionConfigContainers) {
        if ("index".equals(actionName)) {
            ActionConfigContainer namespaceNamingActionConfigContainer = new ActionConfigContainer(Url.NAMESPACE_NAMING, packageConfig.getNamespace(), actionName, packageNamingActionConfigContainer.getActionConfig());
            actionConfigContainers.get((Object)Url.NAMESPACE_NAMING).add(namespaceNamingActionConfigContainer);
        }
    }

    protected void createAliasNamingActionConfigContainer(PackageConfig packageConfig, Class<?> actionClass, String actionClassNamespace, Map<Url, Set<ActionConfigContainer>> actionConfigContainers) {
        ActionConfigContainer aliasActionConfigContainer;
        if (this.viewActionMapping) {
            List<String> viewActionNames = this.viewActionNameHandler.buildAlias(actionClass, actionClassNamespace);
            for (String alias : viewActionNames) {
                aliasActionConfigContainer = new ActionConfigContainer(Url.VIEW_NAMING, actionClass.getName(), packageConfig.getName(), packageConfig.getNamespace(), alias, null);
                packageConfig.addActionConfig(alias, aliasActionConfigContainer.getActionConfig());
                actionConfigContainers.get((Object)Url.VIEW_NAMING).add(aliasActionConfigContainer);
            }
        }
        if (this.actionNameUnknownHandler != null) {
            List<String> actionNames = this.actionNameUnknownHandler.buildAlias(actionClass, actionClassNamespace);
            for (String alias : actionNames) {
                aliasActionConfigContainer = new ActionConfigContainer(Url.PACKAGE_NAMING, actionClass.getName(), packageConfig.getName(), packageConfig.getNamespace(), alias, null);
                packageConfig.addActionConfig(alias, aliasActionConfigContainer.getActionConfig());
                actionConfigContainers.get((Object)Url.PACKAGE_NAMING).add(aliasActionConfigContainer);
            }
        }
    }

    protected void createAnnotationNamingActionConfigContainers(PackageConfig packageConfig, Class<?> actionClass, Map<Url, Set<ActionConfigContainer>> actionConfigContainers) {
        for (Method method : actionClass.getDeclaredMethods()) {
            if (method.isAnnotationPresent(Actions.class)) {
                Actions actions = method.getAnnotation(Actions.class);
                for (com.demo2do.lighturl.annotation.Action action : actions.value()) {
                    this.createActionConfigContainerByAnnotation(action.value(), packageConfig, actionClass, method.getName(), actionConfigContainers);
                }
                continue;
            }
            if (!method.isAnnotationPresent(com.demo2do.lighturl.annotation.Action.class)) continue;
            com.demo2do.lighturl.annotation.Action action = method.getAnnotation(com.demo2do.lighturl.annotation.Action.class);
            this.createActionConfigContainerByAnnotation(action.value(), packageConfig, actionClass, method.getName(), actionConfigContainers);
        }
    }

    protected void createActionConfigContainerByAnnotation(String url, PackageConfig packageConfig, Class<?> actionClass, String methodName, Map<Url, Set<ActionConfigContainer>> actionConfigContainers) {
        if (UrlMatcher.isTemplate(url)) {
            ActionConfigContainer templateUrlActionConfigContainer = new ActionConfigContainer(Url.TEMPLATE_NAMING, actionClass.getName(), packageConfig.getName(), packageConfig.getNamespace(), url, methodName);
            packageConfig.addActionConfig(url, templateUrlActionConfigContainer.getActionConfig());
            Set<ActionConfigContainer> templateUrlNamingActionConfigContainers = actionConfigContainers.get((Object)Url.TEMPLATE_NAMING);
            UrlTemplate urlTemplate = new UrlTemplate(url);
            for (ActionConfigContainer container : templateUrlNamingActionConfigContainers) {
                if (!urlTemplate.match(container.getActionName())) continue;
                throw new ConfigurationException("Find duplicated annotation config definition for action [" + container.getActionName() + "]" + " and [" + urlTemplate.get() + "]");
            }
            templateUrlNamingActionConfigContainers.add(templateUrlActionConfigContainer);
        } else if (UrlMatcher.isFull(url)) {
            Set<ActionConfigContainer> fullUrlNamingActionConfigContainers = actionConfigContainers.get((Object)Url.FULL_NAMING);
            ActionConfigContainer fullUrlActionConfigContainer = new ActionConfigContainer(Url.FULL_NAMING, actionClass.getName(), packageConfig.getName(), packageConfig.getNamespace(), url, methodName);
            packageConfig.addActionConfig(url, fullUrlActionConfigContainer.getActionConfig());
            fullUrlNamingActionConfigContainers.add(fullUrlActionConfigContainer);
        } else if (UrlMatcher.isAntPath(url)) {
            Set<ActionConfigContainer> antPathNamingActionConfigContainers = actionConfigContainers.get((Object)Url.ANTPATH_NAMING);
            ActionConfigContainer antPathActionConfigContainer = new ActionConfigContainer(Url.ANTPATH_NAMING, actionClass.getName(), packageConfig.getName(), packageConfig.getNamespace(), url, methodName);
            packageConfig.addActionConfig(url, antPathActionConfigContainer.getActionConfig());
            antPathNamingActionConfigContainers.add(antPathActionConfigContainer);
        }
    }

    protected void addToRuntimeConfiguration(Map<String, PackageConfig> packageConfigs) {
        Set<String> packageNames = packageConfigs.keySet();
        for (String packageName : packageNames) {
            this.configuration.addPackageConfig(packageName, packageConfigs.get(packageName));
        }
        this.configuration.rebuildRuntimeConfiguration();
    }

    protected void addActionConfigContainersToActionConfigMapping(Map<Url, Set<ActionConfigContainer>> actionConfigContainerMap) {
        ActionConfigMapping actionConfigMapping = new ActionConfigMapping();
        for (Map.Entry<Url, Set<ActionConfigContainer>> entry : actionConfigContainerMap.entrySet()) {
            Url url = entry.getKey();
            Set<ActionConfigContainer> actionConfigContainers = entry.getValue();
            for (ActionConfigContainer container : actionConfigContainers) {
                ActionMapping actionMapping;
                ActionMappingHandler handler = this.actionMappingBuilder.getHandler(url);
                String key = handler.getKey(container.getNamespace(), container.getActionName());
                if (url == Url.NAMESPACE_NAMING || url == Url.PACKAGE_NAMING) {
                    actionMapping = handler.build(container, actionConfigMapping);
                    actionConfigMapping.put(url, handler.getKey(container.getNamespace(), container.getActionName()), actionMapping);
                    continue;
                }
                if (url == Url.FULL_NAMING) {
                    if (actionConfigMapping.isNamespaceNaming(url, key)) {
                        logger.warn((Object)("Find duplicated annotation action config [" + key + "] of action class [" + container.getActionConfig().getClassName() + "] with " + "namespace actionConfig mapping.  The namespace actionConfig will have high priority."));
                    }
                    if (actionConfigMapping.isPackageNaming(url, key)) {
                        logger.warn((Object)("Find duplicated annotation action config [" + key + "] of action class [" + container.getActionConfig().getClassName() + "] with " + "package actionConfig mapping namespace.  This annotation actionConfig will have high priority."));
                    }
                    actionMapping = handler.build(container, actionConfigMapping);
                    actionConfigMapping.put(url, handler.getKey(container.getNamespace(), container.getActionName()), actionMapping);
                    continue;
                }
                if (url == Url.ANTPATH_NAMING) {
                    if (actionConfigMapping.isNamespaceNaming(url, key)) {
                        logger.warn((Object)("Find duplicated annotation action config [" + key + "] of action class [" + container.getActionConfig().getClassName() + "] with " + "namespace actionConfig mapping.  The namespace actionConfig will have high priority."));
                    }
                    if (actionConfigMapping.isPackageNaming(url, key)) {
                        logger.warn((Object)("Find duplicated annotation action config [" + key + "] of action class [" + container.getActionConfig().getClassName() + "] with " + "package actionConfig mapping namespace.  This annotation actionConfig will have high priority."));
                    }
                    actionMapping = handler.build(container, actionConfigMapping);
                    actionConfigMapping.put(url, handler.getKey(container.getNamespace(), container.getActionName()), actionMapping);
                    continue;
                }
                if (url == Url.TEMPLATE_NAMING) {
                    for (String fullMatchedKey : actionConfigMapping.getFullMatchedKeys()) {
                        if (!fullMatchedKey.matches(key)) continue;
                        throw new ConfigurationException("Find duplicated annotation config definition [" + key + "] " + "with " + (Object)((Object)container.getUrl()) + " url, namespace [" + container.getNamespace() + "] " + "and actionName [" + container.getActionName() + "]");
                    }
                    actionMapping = handler.build(container, actionConfigMapping);
                    actionConfigMapping.put(url, handler.getKey(container.getNamespace(), container.getActionName()), actionMapping);
                    continue;
                }
                if (url != Url.VIEW_NAMING) continue;
                if (actionConfigMapping.getConvertedViewNamingKeys().contains(key)) {
                    throw new ConfigurationException("Find duplicated annotation config definitation [" + key + "]" + "with " + (Object)((Object)Url.VIEW_NAMING) + " url [" + container.getNamespace() + "/${id}]");
                }
                actionMapping = handler.build(container, actionConfigMapping);
                actionConfigMapping.put(container.getUrl(), handler.getKey(container.getNamespace(), container.getActionName()), actionMapping);
            }
        }
        this.servletContext.setAttribute("_ACTION_MAPPINGS", (Object)actionConfigMapping);
    }

    private Map<Url, Set<ActionConfigContainer>> createActionConfigContainers() {
        LinkedHashMap<Url, Set<ActionConfigContainer>> actionConfigContainers = new LinkedHashMap<Url, Set<ActionConfigContainer>>();
        actionConfigContainers.put(Url.NAMESPACE_NAMING, new LinkedHashSet());
        actionConfigContainers.put(Url.PACKAGE_NAMING, new LinkedHashSet());
        actionConfigContainers.put(Url.FULL_NAMING, new LinkedHashSet());
        actionConfigContainers.put(Url.ANTPATH_NAMING, new LinkedHashSet());
        actionConfigContainers.put(Url.TEMPLATE_NAMING, new LinkedHashSet());
        actionConfigContainers.put(Url.VIEW_NAMING, new LinkedHashSet());
        return actionConfigContainers;
    }

    private String getNamespace(String actionClassPackage, String ... actionPackages) {
        String namespace = "";
        for (String actionPackage : actionPackages) {
            if (!actionClassPackage.startsWith(actionPackage)) continue;
            if (!actionClassPackage.equals(actionPackage)) {
                int indexOfDot = actionClassPackage.indexOf(actionPackage) + actionPackage.length() + 1;
                if (!StringUtils.isNotEmpty((String)actionClassPackage.substring(indexOfDot))) break;
                String convertedNamespace = this.actionUrlBuilder.build(actionClassPackage.substring(indexOfDot));
                namespace = "/" + convertedNamespace.replace('.', '/');
                break;
            }
            namespace = "/";
            break;
        }
        return namespace;
    }

    private String getActionName(Class<?> actionClass) {
        int lastDotIndex = actionClass.getName().lastIndexOf(".");
        return this.actionUrlBuilder.build(actionClass.getName().substring(lastDotIndex + 1));
    }
}

