/*
 * Decompiled with CFR 0.152.
 */
package com.demo2do.lighturl;

import com.opensymphony.xwork2.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.dispatcher.FilterDispatcher;

public class LightURLFilter
extends FilterDispatcher {
    private static final Log logger = LogFactory.getLog(LightURLFilter.class);
    private static List<String> allowedExtensions;

    @Inject(value="lighturl.filter.allowed.extensions", required=false)
    public static void setAllowedExtensions(String extensions) {
        allowedExtensions = new ArrayList<String>();
        if (extensions != null) {
            allowedExtensions = Arrays.asList(extensions.split("\\s*[,]\\s*"));
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LightURLFilterConfig filterConfigProxy = new LightURLFilterConfig(filterConfig);
        super.init((FilterConfig)filterConfigProxy);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean action;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String uri = httpRequest.getRequestURI();
        int index = uri.lastIndexOf(".");
        boolean bl = action = index < 0;
        if (!action) {
            int slashIndex = uri.indexOf("/", index);
            String extension = uri.substring(index + 1);
            action = slashIndex >= 0 || allowedExtensions != null && allowedExtensions.contains(extension);
        }
        if (action) {
            super.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public static class LightURLFilterConfig
    implements FilterConfig {
        private final FilterConfig filterConfig;
        private static final String CONFIG_PROVIDERS = "configProviders";
        private static final String LIGHTURL_CONFIGURATION_PROVIDER = "com.demo2do.lighturl.LightURLConfigurationProvider";

        public LightURLFilterConfig(FilterConfig filterConfig) {
            this.filterConfig = filterConfig;
        }

        public String getFilterName() {
            return this.filterConfig.getFilterName();
        }

        public ServletContext getServletContext() {
            return this.filterConfig.getServletContext();
        }

        public String getInitParameter(String parameterName) {
            if (parameterName.equals(CONFIG_PROVIDERS)) {
                String existing = this.filterConfig.getInitParameter(parameterName);
                if (existing != null && !existing.contains(LIGHTURL_CONFIGURATION_PROVIDER)) {
                    existing = "com.demo2do.lighturl.LightURLConfigurationProvider," + existing;
                } else if (existing == null) {
                    existing = LIGHTURL_CONFIGURATION_PROVIDER;
                }
                return existing;
            }
            return this.filterConfig.getInitParameter(parameterName);
        }

        public Enumeration getInitParameterNames() {
            Vector<String> names = new Vector<String>();
            Enumeration e = this.filterConfig.getInitParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                names.add(name);
            }
            if (!names.contains(CONFIG_PROVIDERS)) {
                names.add(CONFIG_PROVIDERS);
            }
            return names.elements();
        }
    }
}

