/*
 * Decompiled with CFR 0.152.
 */
package com.demo2do.lighturl;

import com.demo2do.lighturl.mapping.ActionConfigMapping;
import com.demo2do.lighturl.mapping.ActionMappingBuilder;
import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.RequestUtils;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.dispatcher.mapper.DefaultActionMapper;

public class LightURLActionMapper
extends DefaultActionMapper
implements ActionMapper {
    private static final Log logger = LogFactory.getLog(LightURLActionMapper.class);
    @Inject
    private ServletContext servletContext;
    @Inject
    private ActionMappingBuilder actionMappingBuilder;

    public ActionMapping getMapping(HttpServletRequest request, ConfigurationManager configManager) {
        ActionConfigMapping actionConfigMapping = (ActionConfigMapping)this.servletContext.getAttribute("_ACTION_MAPPINGS");
        String uri = this.getRequestURI(request);
        String[] requestURI = this.handleMethod(uri);
        ActionMapping actionMapping = this.actionMappingBuilder.build(requestURI[0], actionConfigMapping);
        if (actionMapping != null && requestURI[1] != null) {
            actionMapping.setMethod(requestURI[1]);
        }
        return actionMapping == null ? super.getMapping(request, configManager) : actionMapping;
    }

    protected String getRequestURI(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri != null) {
            return uri;
        }
        uri = RequestUtils.getServletPath((HttpServletRequest)request);
        if (uri != null && !"".equals(uri)) {
            return uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
        }
        uri = request.getRequestURI().substring(request.getContextPath().length());
        return uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
    }

    protected String[] handleMethod(String requestURI) {
        String[] result = new String[2];
        if (StringUtils.isEmpty((String)requestURI)) {
            result[0] = "/";
        } else {
            String lastPart = requestURI.substring(requestURI.lastIndexOf("/") + 1);
            int methodFlag = lastPart.indexOf("!");
            if (methodFlag != -1) {
                result[0] = requestURI.substring(0, requestURI.length() - methodFlag - 1);
                result[1] = requestURI.substring(requestURI.length() - methodFlag);
            } else {
                result[0] = requestURI;
            }
        }
        return result;
    }
}

