/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.GenericArrayTypeInformation;
import org.springframework.data.util.ParameterizedTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.data.util.TypeVariableTypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeDiscoverer<S>
implements TypeInformation<S> {
    private final Type type;
    private final Map<TypeVariable, Type> typeVariableMap;
    private final Map<String, TypeInformation<?>> fieldTypes = new ConcurrentHashMap();

    protected TypeDiscoverer(Type type, Map<TypeVariable, Type> typeVariableMap) {
        Assert.notNull((Object)type);
        this.type = type;
        this.typeVariableMap = typeVariableMap;
    }

    protected Map<TypeVariable, Type> getTypeVariableMap() {
        return this.typeVariableMap;
    }

    protected TypeInformation<?> createInfo(Type fieldType) {
        if (fieldType.equals(this.type)) {
            return this;
        }
        if (fieldType instanceof Class) {
            return new ClassTypeInformation((Class)fieldType);
        }
        Map variableMap = GenericTypeResolver.getTypeVariableMap(this.resolveType(fieldType));
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)fieldType;
            return new ParameterizedTypeInformation(parameterizedType, this);
        }
        if (fieldType instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)fieldType;
            return new TypeVariableTypeInformation(variable, this.type, this, variableMap);
        }
        if (fieldType instanceof GenericArrayType) {
            return new GenericArrayTypeInformation((GenericArrayType)fieldType, this);
        }
        if (fieldType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)fieldType;
            Type[] bounds = wildcardType.getLowerBounds();
            if (bounds.length > 0) {
                return this.createInfo(bounds[0]);
            }
            bounds = wildcardType.getUpperBounds();
            if (bounds.length > 0) {
                return this.createInfo(bounds[0]);
            }
        }
        throw new IllegalArgumentException();
    }

    protected Class<S> resolveType(Type type) {
        return GenericTypeResolver.resolveType((Type)type, this.getTypeVariableMap());
    }

    @Override
    public List<TypeInformation<?>> getParameterTypes(Constructor<?> constructor) {
        ArrayList result = new ArrayList();
        for (Type type : constructor.getGenericParameterTypes()) {
            result.add(this.createInfo(type));
        }
        return result;
    }

    @Override
    public TypeInformation<?> getProperty(String fieldname) {
        int separatorIndex = fieldname.indexOf(46);
        if (separatorIndex == -1) {
            if (this.fieldTypes.containsKey(fieldname)) {
                return this.fieldTypes.get(fieldname);
            }
            TypeInformation<?> propertyInformation = this.getPropertyInformation(fieldname);
            if (propertyInformation != null) {
                this.fieldTypes.put(fieldname, propertyInformation);
            }
            return propertyInformation;
        }
        String head = fieldname.substring(0, separatorIndex);
        TypeInformation<?> info = this.fieldTypes.get(head);
        return info == null ? null : info.getProperty(fieldname.substring(separatorIndex + 1));
    }

    private TypeInformation<?> getPropertyInformation(String fieldname) {
        Class<S> type = this.getType();
        Field field = ReflectionUtils.findField(type, (String)fieldname);
        if (field != null) {
            return this.createInfo(field.getGenericType());
        }
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(type, (String)fieldname);
        return descriptor == null ? null : this.createInfo(TypeDiscoverer.getGenericType(descriptor));
    }

    private static Type getGenericType(PropertyDescriptor descriptor) {
        Method method = descriptor.getReadMethod();
        if (method != null) {
            return method.getGenericReturnType();
        }
        method = descriptor.getWriteMethod();
        if (method == null) {
            return null;
        }
        Type[] parameterTypes = method.getGenericParameterTypes();
        return parameterTypes.length == 0 ? null : parameterTypes[0];
    }

    @Override
    public Class<S> getType() {
        return this.resolveType(this.type);
    }

    @Override
    public TypeInformation<?> getActualType() {
        if (this.isMap()) {
            return this.getMapValueType();
        }
        if (this.isCollectionLike()) {
            return this.getComponentType();
        }
        return this;
    }

    @Override
    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    @Override
    public TypeInformation<?> getMapValueType() {
        if (!this.isMap()) {
            return null;
        }
        return this.getTypeArgument(this.getType(), Map.class, 1);
    }

    private TypeInformation<?> getTypeArgument(Class<?> type, Class<?> bound, int index) {
        Class[] arguments = GenericTypeResolver.resolveTypeArguments(type, bound);
        return arguments == null ? null : this.createInfo(arguments[index]);
    }

    @Override
    public boolean isCollectionLike() {
        Class<S> rawType = this.getType();
        if (rawType.isArray() || Iterable.class.equals(rawType)) {
            return true;
        }
        return Collection.class.isAssignableFrom(rawType);
    }

    @Override
    public TypeInformation<?> getComponentType() {
        Class<S> rawType = this.getType();
        if (!(this.isMap() || this.isCollectionLike() || Iterable.class.isAssignableFrom(rawType))) {
            return null;
        }
        if (this.type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)this.type;
            return this.createInfo(parameterizedType.getActualTypeArguments()[0]);
        }
        if (this.isMap()) {
            return this.getTypeArgument(rawType, Map.class, 0);
        }
        if (Iterable.class.isAssignableFrom(rawType)) {
            return this.getTypeArgument(rawType, Iterable.class, 0);
        }
        if (rawType.isArray()) {
            return this.createInfo(rawType.getComponentType());
        }
        return null;
    }

    @Override
    public TypeInformation<?> getReturnType(Method method) {
        Assert.notNull((Object)method);
        return this.createInfo(method.getGenericReturnType());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        TypeDiscoverer that = (TypeDiscoverer)obj;
        boolean typeEqual = ObjectUtils.nullSafeEquals((Object)this.type, (Object)that.type);
        boolean typeVariableMapEqual = ObjectUtils.nullSafeEquals(this.typeVariableMap, that.typeVariableMap);
        return typeEqual && typeVariableMapEqual;
    }

    public int hashCode() {
        int result = 17;
        result += ObjectUtils.nullSafeHashCode((Object)this.type);
        return result += ObjectUtils.nullSafeHashCode(this.typeVariableMap);
    }
}

