/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.util.ParentTypeAwareTypeInformation;
import org.springframework.data.util.TypeDiscoverer;
import org.springframework.data.util.TypeInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterizedTypeInformation<T>
extends ParentTypeAwareTypeInformation<T> {
    private final ParameterizedType type;

    public ParameterizedTypeInformation(ParameterizedType type, TypeDiscoverer<?> parent) {
        super(type, parent, null);
        this.type = type;
    }

    @Override
    public TypeInformation<?> getMapValueType() {
        if (Map.class.equals((Object)this.getType())) {
            Type[] arguments = this.type.getActualTypeArguments();
            return this.createInfo(arguments[1]);
        }
        Class rawType = this.getType();
        HashSet<Type> supertypes = new HashSet<Type>();
        supertypes.add(rawType.getGenericSuperclass());
        supertypes.addAll(Arrays.asList(rawType.getGenericInterfaces()));
        for (Type supertype : supertypes) {
            Class rawSuperType = GenericTypeResolver.resolveType((Type)supertype, this.getTypeVariableMap());
            if (!Map.class.isAssignableFrom(rawSuperType)) continue;
            ParameterizedType parameterizedSupertype = (ParameterizedType)supertype;
            Type[] arguments = parameterizedSupertype.getActualTypeArguments();
            return this.createInfo(arguments[1]);
        }
        return super.getMapValueType();
    }
}

