/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.Collection;
import java.util.HashSet;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.config.CommonRepositoryConfigInformation;
import org.springframework.data.repository.config.GlobalRepositoryConfigInformation;
import org.springframework.data.repository.config.SingleRepositoryConfigInformation;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositoryConfig<T extends SingleRepositoryConfigInformation<S>, S extends CommonRepositoryConfigInformation>
implements GlobalRepositoryConfigInformation<T> {
    public static final String DEFAULT_REPOSITORY_IMPL_POSTFIX = "Impl";
    public static final String QUERY_LOOKUP_STRATEGY = "query-lookup-strategy";
    public static final String BASE_PACKAGE = "base-package";
    public static final String REPOSITORY_IMPL_POSTFIX = "repository-impl-postfix";
    public static final String REPOSITORY_FACTORY_CLASS_NAME = "factory-class";
    public static final String TRANSACTION_MANAGER_REF = "transaction-manager-ref";
    private final Element element;
    private final String defaultRepositoryFactoryBeanClassName;

    protected RepositoryConfig(Element repositoriesElement, String defaultRepositoryFactoryBeanClassName) {
        Assert.notNull((Object)repositoriesElement, (String)"Element must not be null!");
        Assert.notNull((Object)defaultRepositoryFactoryBeanClassName, (String)"Default repository factory bean class name must not be null!");
        this.element = repositoriesElement;
        this.defaultRepositoryFactoryBeanClassName = defaultRepositoryFactoryBeanClassName;
    }

    @Override
    public Element getSource() {
        return this.element;
    }

    @Override
    public boolean configureManually() {
        return this.getRepositoryElements().size() > 0;
    }

    @Override
    public QueryLookupStrategy.Key getQueryLookupStrategyKey() {
        String createFinderQueries = this.element.getAttribute(QUERY_LOOKUP_STRATEGY);
        return StringUtils.hasText((String)createFinderQueries) ? QueryLookupStrategy.Key.create(createFinderQueries) : null;
    }

    @Override
    public String getBasePackage() {
        return this.element.getAttribute(BASE_PACKAGE);
    }

    @Override
    public String getRepositoryFactoryBeanClassName() {
        String factoryClassName = this.getSource().getAttribute(REPOSITORY_FACTORY_CLASS_NAME);
        return StringUtils.hasText((String)factoryClassName) ? factoryClassName : this.defaultRepositoryFactoryBeanClassName;
    }

    @Override
    public String getRepositoryImplementationSuffix() {
        String postfix = this.element.getAttribute(REPOSITORY_IMPL_POSTFIX);
        return StringUtils.hasText((String)postfix) ? postfix : DEFAULT_REPOSITORY_IMPL_POSTFIX;
    }

    @Override
    public String getTransactionManagerRef() {
        String ref = this.element.getAttribute(TRANSACTION_MANAGER_REF);
        return StringUtils.hasText((String)ref) ? ref : null;
    }

    @Override
    public Iterable<T> getSingleRepositoryConfigInformations() {
        HashSet<T> infos = new HashSet<T>();
        for (Element repositoryElement : this.getRepositoryElements()) {
            infos.add(this.createSingleRepositoryConfigInformationFor(repositoryElement));
        }
        return infos;
    }

    @Override
    public Class<?> getRepositoryBaseInterface() {
        return Repository.class;
    }

    private Collection<Element> getRepositoryElements() {
        NodeList nodes = this.element.getChildNodes();
        HashSet<Element> result = new HashSet<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            boolean isElement = 1 == node.getNodeType();
            boolean isRepository = "repository".equals(node.getLocalName());
            if (!isElement || !isRepository) continue;
            result.add((Element)node);
        }
        return result;
    }

    protected abstract T createSingleRepositoryConfigInformationFor(Element var1);
}

