/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import org.springframework.data.repository.config.CommonRepositoryConfigInformation;
import org.springframework.data.repository.config.ParentDelegatingRepositoryConfigInformation;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManualRepositoryConfigInformation<T extends CommonRepositoryConfigInformation>
extends ParentDelegatingRepositoryConfigInformation<T> {
    private static final String CUSTOM_IMPL_REF = "custom-impl-ref";
    private Element element;

    public ManualRepositoryConfigInformation(Element element, T parent) {
        super(parent);
        this.element = element;
    }

    @Override
    public String getBeanId() {
        return this.element.getAttribute("id");
    }

    @Override
    public String getInterfaceName() {
        return this.getBasePackage() + "." + StringUtils.capitalize((String)this.getBeanId());
    }

    @Override
    public String getCustomImplementationRef() {
        return this.element.getAttribute(CUSTOM_IMPL_REF);
    }

    @Override
    public boolean autodetectCustomImplementation() {
        return !StringUtils.hasText((String)this.getCustomImplementationRef());
    }

    @Override
    public String getRepositoryImplementationSuffix() {
        String value = this.element.getAttribute("repository-impl-postfix");
        return StringUtils.hasText((String)value) ? value : this.getParent().getRepositoryImplementationSuffix();
    }

    @Override
    public String getTransactionManagerRef() {
        return this.getAttribute("transaction-manager-ref");
    }

    @Override
    public Element getSource() {
        return this.element;
    }

    protected String getAttribute(String attribute) {
        String value = this.getSource().getAttribute(attribute);
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        value = this.getParent().getSource().getAttribute(attribute);
        return StringUtils.hasText((String)value) ? value : null;
    }

    @Override
    public String getRepositoryFactoryBeanClassName() {
        String value = this.element.getAttribute("factory-class");
        return StringUtils.hasText((String)value) ? value : this.getParent().getRepositoryFactoryBeanClassName();
    }

    @Override
    public QueryLookupStrategy.Key getQueryLookupStrategyKey() {
        return QueryLookupStrategy.Key.create(this.getAttribute("query-lookup-strategy"));
    }
}

