/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate3.type;

import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;
import org.jasypt.commons.CommonUtils;
import org.jasypt.hibernate3.type.AbstractEncryptedAsStringType;

public final class EncryptedCalendarAsStringType
extends AbstractEncryptedAsStringType {
    private Boolean storeTimeZone = Boolean.FALSE;

    protected Object convertToObject(String string) {
        String[] stringTokens = CommonUtils.split((String)string);
        TimeZone tz = null;
        long timeMillis = Long.valueOf(stringTokens[0]);
        tz = this.storeTimeZone != false ? TimeZone.getTimeZone(stringTokens[1]) : TimeZone.getDefault();
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(tz);
        cal.setTimeInMillis(timeMillis);
        return cal;
    }

    protected String convertToString(Object object) {
        StringBuffer strBuff = new StringBuffer();
        long timeMillis = ((Calendar)object).getTimeInMillis();
        strBuff.append(new Long(timeMillis).toString());
        if (this.storeTimeZone.booleanValue()) {
            strBuff.append(" ");
            strBuff.append(((Calendar)object).getTimeZone().getID());
        }
        return strBuff.toString();
    }

    public synchronized void setParameterValues(Properties parameters) {
        super.setParameterValues(parameters);
        String paramStoreTimeZone = parameters.getProperty("storeTimeZone");
        if (paramStoreTimeZone != null && !paramStoreTimeZone.trim().equals("")) {
            this.storeTimeZone = CommonUtils.getStandardBooleanValue((String)paramStoreTimeZone);
        }
    }

    public Class returnedClass() {
        return Calendar.class;
    }
}

