/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Transient;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.FieldManifestation;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.StubMethod;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.StreamDrainer;
import org.hibernate.bytecode.enhance.internal.bytebuddy.ByteBuddyEnhancementContext;
import org.hibernate.bytecode.enhance.internal.bytebuddy.CodeTemplates;
import org.hibernate.bytecode.enhance.internal.bytebuddy.PersistentAttributeTransformer;
import org.hibernate.bytecode.enhance.internal.tracker.CompositeOwnerTracker;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.Managed;
import org.hibernate.engine.spi.ManagedComposite;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.ManagedMappedSuperclass;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class EnhancerImpl
implements Enhancer {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Enhancer.class);
    protected final ByteBuddyEnhancementContext enhancementContext;
    private final TypePool classPool;

    public EnhancerImpl(EnhancementContext enhancementContext) {
        this.enhancementContext = new ByteBuddyEnhancementContext(enhancementContext);
        this.classPool = this.buildClassPool(this.enhancementContext);
    }

    @Override
    public synchronized byte[] enhance(String className, byte[] originalBytes) throws EnhancementException {
        try {
            TypeDescription managedCtClass = this.classPool.describe(className).resolve();
            DynamicType.Builder<?> builder = this.doEnhance(new ByteBuddy().with(TypeValidation.DISABLED).redefine(managedCtClass, ClassFileLocator.Simple.of((String)className, (byte[])originalBytes)), managedCtClass);
            if (builder == null) {
                return null;
            }
            return builder.make().getBytes();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            log.unableToBuildEnhancementMetamodel(className);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] enhance(File javaClassFile) throws EnhancementException, IOException {
        String name = javaClassFile.getName().substring(0, javaClassFile.getName().length() - ".class".length());
        try (FileInputStream inputStream = new FileInputStream(javaClassFile);){
            byte[] byArray = this.enhance(name, StreamDrainer.DEFAULT.drain((InputStream)inputStream));
            return byArray;
        }
    }

    private TypePool buildClassPool(ByteBuddyEnhancementContext enhancementContext) {
        return TypePool.Default.WithLazyResolution.of((ClassLoader)enhancementContext.getLoadingClassLoader());
    }

    private DynamicType.Builder<?> doEnhance(DynamicType.Builder<?> builder, TypeDescription managedCtClass) {
        if (managedCtClass.isInterface()) {
            log.debugf("Skipping enhancement of [%s]: it's an interface!", managedCtClass.getName());
            return null;
        }
        if (this.alreadyEnhanced(managedCtClass)) {
            log.debugf("Skipping enhancement of [%s]: already enhanced", managedCtClass.getName());
            return null;
        }
        PersistentAttributeTransformer transformer = PersistentAttributeTransformer.collectPersistentFields(managedCtClass, this.enhancementContext, this.classPool);
        if (this.enhancementContext.isEntityClass(managedCtClass)) {
            log.infof("Enhancing [%s] as Entity", managedCtClass.getName());
            builder = builder.implement(new Type[]{ManagedEntity.class}).defineMethod("$$_hibernate_getEntityInstance", Object.class, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept(FixedValue.self());
            builder = EnhancerImpl.addFieldWithGetterAndSetter(builder, EntityEntry.class, "$$_hibernate_entityEntryHolder", "$$_hibernate_getEntityEntry", "$$_hibernate_setEntityEntry");
            builder = EnhancerImpl.addFieldWithGetterAndSetter(builder, ManagedEntity.class, "$$_hibernate_previousManagedEntity", "$$_hibernate_getPreviousManagedEntity", "$$_hibernate_setPreviousManagedEntity");
            builder = EnhancerImpl.addFieldWithGetterAndSetter(builder, ManagedEntity.class, "$$_hibernate_nextManagedEntity", "$$_hibernate_getNextManagedEntity", "$$_hibernate_setNextManagedEntity");
            builder = this.addInterceptorHandling((DynamicType.Builder<?>)builder, managedCtClass);
            if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
                builder = builder.implement(new Type[]{ExtendedSelfDirtinessTracker.class}).defineField("$$_hibernate_tracker", DirtyTracker.class, new ModifierContributor.ForField[]{FieldManifestation.TRANSIENT, Visibility.PRIVATE}).annotateField(new AnnotationDescription[]{AnnotationDescription.Builder.ofType(Transient.class).build()}).defineField("$$_hibernate_collectionTracker", CollectionTracker.class, new ModifierContributor.ForField[]{FieldManifestation.TRANSIENT, Visibility.PRIVATE}).annotateField(new AnnotationDescription[]{AnnotationDescription.Builder.ofType(Transient.class).build()}).defineMethod("$$_hibernate_trackChange", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameters(new Type[]{String.class}).intercept(Advice.to(CodeTemplates.TrackChange.class).wrap((Implementation)StubMethod.INSTANCE)).defineMethod("$$_hibernate_getDirtyAttributes", String[].class, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept(Advice.to(CodeTemplates.GetDirtyAttributes.class).wrap((Implementation)StubMethod.INSTANCE)).defineMethod("$$_hibernate_hasDirtyAttributes", Boolean.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept(Advice.to(CodeTemplates.AreCollectionFieldsDirty.class).wrap((Implementation)StubMethod.INSTANCE)).defineMethod("$$_hibernate_clearDirtyAttributes", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept(Advice.to(CodeTemplates.ClearDirtyAttributes.class).wrap((Implementation)StubMethod.INSTANCE)).defineMethod("$$_hibernate_suspendDirtyTracking", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameters(new Type[]{Boolean.TYPE}).intercept(Advice.to(CodeTemplates.SuspendDirtyTracking.class).wrap((Implementation)StubMethod.INSTANCE)).defineMethod("$$_hibernate_getCollectionTracker", CollectionTracker.class, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)FieldAccessor.ofField((String)"$$_hibernate_collectionTracker"));
                StubMethod isDirty = StubMethod.INSTANCE;
                StubMethod getDirtyNames = StubMethod.INSTANCE;
                StubMethod clearDirtyNames = StubMethod.INSTANCE;
                for (FieldDescription collectionField : this.collectCollectionFields(managedCtClass)) {
                    if (this.enhancementContext.isMappedCollection(collectionField)) continue;
                    if (collectionField.getType().asErasure().isAssignableTo(Map.class)) {
                        isDirty = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Serializable)((Object)collectionField.getName())).bind(CodeTemplates.FieldValue.class, collectionField).to(CodeTemplates.MapAreCollectionFieldsDirty.class).wrap((Implementation)isDirty);
                        getDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Serializable)((Object)collectionField.getName())).bind(CodeTemplates.FieldValue.class, collectionField).to(CodeTemplates.MapGetCollectionFieldDirtyNames.class).wrap((Implementation)getDirtyNames);
                        clearDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Serializable)((Object)collectionField.getName())).bind(CodeTemplates.FieldValue.class, collectionField).to(CodeTemplates.MapGetCollectionClearDirtyNames.class).wrap((Implementation)clearDirtyNames);
                        continue;
                    }
                    isDirty = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Serializable)((Object)collectionField.getName())).bind(CodeTemplates.FieldValue.class, collectionField).to(CodeTemplates.CollectionAreCollectionFieldsDirty.class).wrap((Implementation)isDirty);
                    getDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Serializable)((Object)collectionField.getName())).bind(CodeTemplates.FieldValue.class, collectionField).to(CodeTemplates.CollectionGetCollectionFieldDirtyNames.class).wrap((Implementation)getDirtyNames);
                    clearDirtyNames = Advice.withCustomMapping().bind(CodeTemplates.FieldName.class, (Serializable)((Object)collectionField.getName())).bind(CodeTemplates.FieldValue.class, collectionField).to(CodeTemplates.CollectionGetCollectionClearDirtyNames.class).wrap((Implementation)clearDirtyNames);
                }
                if (this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
                    clearDirtyNames = Advice.to(CodeTemplates.InitializeLazyAttributeLoadingInterceptor.class).wrap((Implementation)clearDirtyNames);
                }
                builder = builder.defineMethod("$$_hibernate_areCollectionFieldsDirty", Boolean.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)isDirty).defineMethod("$$_hibernate_getCollectionFieldDirtyNames", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameters(new Type[]{DirtyTracker.class}).intercept((Implementation)getDirtyNames).defineMethod("$$_hibernate_clearDirtyCollectionNames", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept(Advice.withCustomMapping().to(CodeTemplates.ClearDirtyCollectionNames.class).wrap((Implementation)StubMethod.INSTANCE)).defineMethod("$$_hibernate_removeDirtyFields", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameters(new Type[]{LazyAttributeLoadingInterceptor.class}).intercept((Implementation)clearDirtyNames);
            }
            return transformer.applyTo((DynamicType.Builder<?>)builder, false);
        }
        if (this.enhancementContext.isCompositeClass(managedCtClass)) {
            log.infof("Enhancing [%s] as Composite", managedCtClass.getName());
            builder = builder.implement(new Type[]{ManagedComposite.class});
            builder = this.addInterceptorHandling((DynamicType.Builder<?>)builder, managedCtClass);
            if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
                builder = builder.implement(new Type[]{CompositeTracker.class}).defineField("$$_hibernate_compositeOwners", CompositeOwnerTracker.class, new ModifierContributor.ForField[]{FieldManifestation.TRANSIENT, Visibility.PRIVATE}).annotateField(new AnnotationDescription[]{AnnotationDescription.Builder.ofType(Transient.class).build()}).defineMethod("$$_hibernate_setOwner", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameters(new Type[]{String.class, CompositeOwner.class}).intercept(Advice.to(CodeTemplates.SetOwner.class).wrap((Implementation)StubMethod.INSTANCE)).defineMethod("$$_hibernate_clearOwner", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameters(new Type[]{String.class}).intercept(Advice.to(CodeTemplates.ClearOwner.class).wrap((Implementation)StubMethod.INSTANCE));
            }
            return transformer.applyTo((DynamicType.Builder<?>)builder, false);
        }
        if (this.enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            log.infof("Enhancing [%s] as MappedSuperclass", managedCtClass.getName());
            return transformer.applyTo((DynamicType.Builder<?>)builder, true);
        }
        if (this.enhancementContext.doExtendedEnhancement(managedCtClass)) {
            log.infof("Extended enhancement of [%s]", managedCtClass.getName());
            return transformer.applyExtended((DynamicType.Builder<?>)builder);
        }
        log.debugf("Skipping enhancement of [%s]: not entity or composite", managedCtClass.getName());
        return null;
    }

    private boolean alreadyEnhanced(TypeDescription managedCtClass) {
        if (!managedCtClass.isAssignableTo(Managed.class)) {
            return false;
        }
        return this.enhancementContext.isEntityClass(managedCtClass) && managedCtClass.isAssignableTo(ManagedEntity.class) || this.enhancementContext.isCompositeClass(managedCtClass) && managedCtClass.isAssignableTo(ManagedComposite.class) || this.enhancementContext.isMappedSuperclassClass(managedCtClass) && managedCtClass.isAssignableTo(ManagedMappedSuperclass.class);
    }

    private DynamicType.Builder<?> addInterceptorHandling(DynamicType.Builder<?> builder, TypeDescription managedCtClass) {
        if (this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
            log.debugf("Weaving in PersistentAttributeInterceptable implementation on [%s]", managedCtClass.getName());
            builder = builder.implement(new Type[]{PersistentAttributeInterceptable.class});
            builder = EnhancerImpl.addFieldWithGetterAndSetter(builder, PersistentAttributeInterceptor.class, "$$_hibernate_attributeInterceptor", "$$_hibernate_getInterceptor", "$$_hibernate_setInterceptor");
        }
        return builder;
    }

    private static DynamicType.Builder<?> addFieldWithGetterAndSetter(DynamicType.Builder<?> builder, Class<?> type, String fieldName, String getterName, String setterName) {
        return builder.defineField(fieldName, type, new ModifierContributor.ForField[]{Visibility.PRIVATE, FieldManifestation.TRANSIENT}).annotateField(new AnnotationDescription[]{AnnotationDescription.Builder.ofType(Transient.class).build()}).defineMethod(getterName, type, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)FieldAccessor.ofField((String)fieldName)).defineMethod(setterName, Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameters(new Type[]{type}).intercept((Implementation)FieldAccessor.ofField((String)fieldName));
    }

    private List<FieldDescription> collectCollectionFields(TypeDescription managedCtClass) {
        ArrayList<FieldDescription> collectionList = new ArrayList<FieldDescription>();
        for (FieldDescription ctField : managedCtClass.getDeclaredFields()) {
            if (Modifier.isStatic(ctField.getModifiers()) || ctField.getName().startsWith("$$_hibernate_") || !this.enhancementContext.isPersistentField(ctField) || !ctField.getType().asErasure().isAssignableTo(Collection.class) && !ctField.getType().asErasure().isAssignableTo(Map.class)) continue;
            collectionList.add(ctField);
        }
        if (!this.enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            collectionList.addAll(this.collectInheritCollectionFields((TypeDefinition)managedCtClass));
        }
        return collectionList;
    }

    private Collection<FieldDescription> collectInheritCollectionFields(TypeDefinition managedCtClass) {
        TypeDescription.Generic managedCtSuperclass = managedCtClass.getSuperClass();
        if (managedCtSuperclass == null || managedCtSuperclass.represents(Object.class)) {
            return Collections.emptyList();
        }
        if (!this.enhancementContext.isMappedSuperclassClass(managedCtSuperclass.asErasure())) {
            return this.collectInheritCollectionFields((TypeDefinition)managedCtSuperclass.asErasure());
        }
        ArrayList<FieldDescription> collectionList = new ArrayList<FieldDescription>();
        for (FieldDescription ctField : managedCtSuperclass.getDeclaredFields()) {
            if (Modifier.isStatic(ctField.getModifiers()) || !this.enhancementContext.isPersistentField(ctField) || !ctField.getType().asErasure().isAssignableTo(Collection.class) && !ctField.getType().asErasure().isAssignableTo(Map.class)) continue;
            collectionList.add(ctField);
        }
        collectionList.addAll(this.collectInheritCollectionFields((TypeDefinition)managedCtSuperclass));
        return collectionList;
    }

    static String capitalize(String value) {
        return Character.toUpperCase(value.charAt(0)) + value.substring(1);
    }

    static boolean isAnnotationPresent(FieldDescription fieldDescription, Class<? extends Annotation> type) {
        return EnhancerImpl.getAnnotation(fieldDescription, type) != null;
    }

    static <T extends Annotation> AnnotationDescription.Loadable<T> getAnnotation(FieldDescription fieldDescription, Class<T> type) {
        AnnotationDescription.Loadable annotationDescription;
        AnnotationDescription.Loadable access = fieldDescription.getDeclaringType().asErasure().getDeclaredAnnotations().ofType(Access.class);
        if (access != null && ((Access)access.loadSilent()).value() == AccessType.PROPERTY) {
            MethodDescription getter = EnhancerImpl.getterOf(fieldDescription);
            if (getter == null) {
                return fieldDescription.getDeclaredAnnotations().ofType(type);
            }
            return getter.getDeclaredAnnotations().ofType(type);
        }
        if (access != null && ((Access)access.loadSilent()).value() == AccessType.FIELD) {
            return fieldDescription.getDeclaredAnnotations().ofType(type);
        }
        MethodDescription getter = EnhancerImpl.getterOf(fieldDescription);
        if (getter != null && (annotationDescription = getter.getDeclaredAnnotations().ofType(type)) != null) {
            return annotationDescription;
        }
        return fieldDescription.getDeclaredAnnotations().ofType(type);
    }

    static MethodDescription getterOf(FieldDescription persistentField) {
        MethodList methodList = (MethodList)MethodGraph.Compiler.DEFAULT.compile(persistentField.getDeclaringType().asErasure()).listNodes().asMethodList().filter((ElementMatcher)ElementMatchers.isGetter((String)persistentField.getName()));
        if (methodList.size() == 1) {
            return (MethodDescription)methodList.getOnly();
        }
        return null;
    }
}

