/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ajp;

import java.io.IOException;
import java.io.InterruptedIOException;
import javax.servlet.ServletInputStream;
import org.eclipse.jetty.ajp.Ajp13Generator;
import org.eclipse.jetty.ajp.Ajp13RequestPacket;
import org.eclipse.jetty.ajp.Ajp13SocketConnector;
import org.eclipse.jetty.http.Parser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferUtil;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.View;
import org.eclipse.jetty.util.log.Log;

public class Ajp13Parser
implements Parser {
    private static final int STATE_START = -1;
    private static final int STATE_END = 0;
    private static final int STATE_AJP13CHUNK_START = 1;
    private static final int STATE_AJP13CHUNK = 2;
    private int _state = -1;
    private long _contentLength;
    private long _contentPosition;
    private int _chunkLength;
    private int _chunkPosition;
    private int _headers;
    private Buffers _buffers;
    private EndPoint _endp;
    private Buffer _buffer;
    private Buffer _header;
    private Buffer _body;
    private View _contentView = new View();
    private EventHandler _handler;
    private Ajp13Generator _generator;
    private View _tok0;
    private View _tok1;
    protected int _length;
    protected int _packetLength;
    volatile int _seq = 0;

    public Ajp13Parser(Buffers buffers, EndPoint endPoint) {
        this._buffers = buffers;
        this._endp = endPoint;
    }

    public void setEventHandler(EventHandler handler) {
        this._handler = handler;
    }

    public void setGenerator(Ajp13Generator generator) {
        this._generator = generator;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public int getState() {
        return this._state;
    }

    public boolean inContentState() {
        return this._state > 0;
    }

    public boolean inHeaderState() {
        return this._state < 0;
    }

    public boolean isIdle() {
        return this._state == -1;
    }

    public boolean isComplete() {
        return this._state == 0;
    }

    public boolean isMoreInBuffer() {
        return this._header != null && this._header.hasContent() || this._body != null && this._body.hasContent();
    }

    public boolean isState(int state) {
        return this._state == state;
    }

    public void parse() throws IOException {
        if (this._state == 0) {
            this.reset(false);
        }
        if (this._state != -1) {
            throw new IllegalStateException("!START");
        }
        while (!this.isComplete()) {
            this.parseNext();
        }
    }

    public long parseAvailable() throws IOException {
        long total;
        long len = this.parseNext();
        long l = total = len > 0L ? len : 0L;
        while (!this.isComplete() && this._buffer != null && this._buffer.length() > 0 && (len = this.parseNext()) > 0L) {
            total += len;
        }
        return total;
    }

    private int fill() throws IOException {
        int filled = -1;
        if (this._body != null && this._buffer != this._body) {
            if (this._header.length() > 0) {
                this._body.put(this._header);
            }
            this._buffer = this._body;
            if (this._buffer.length() > 0) {
                filled = this._buffer.length();
                return filled;
            }
        }
        if (this._buffer.markIndex() == 0 && this._buffer.putIndex() == this._buffer.capacity()) {
            throw new IOException("FULL");
        }
        if (this._endp != null && filled <= 0) {
            if (this._buffer == this._body) {
                this._buffer.compact();
            }
            if (this._buffer.space() == 0) {
                throw new IOException("FULL");
            }
            try {
                filled = this._endp.fill(this._buffer);
            }
            catch (IOException e) {
                Log.debug((Throwable)e);
                this.reset(true);
                throw e instanceof EofException ? e : new EofException((Throwable)e);
            }
        }
        if (filled < 0) {
            if (this._state > 0) {
                this._state = 0;
                this._handler.messageComplete(this._contentPosition);
                return filled;
            }
            this.reset(true);
            throw new EofException();
        }
        return filled;
    }

    public long parseNext() throws IOException {
        long total_filled = -1L;
        if (this._buffer == null) {
            if (this._header == null) {
                this._header = this._buffers.getHeader();
            }
            this._buffer = this._header;
            this._tok0 = new View(this._header);
            this._tok1 = new View(this._header);
            this._tok0.setPutIndex(this._tok0.getIndex());
            this._tok1.setPutIndex(this._tok1.getIndex());
        }
        if (this._state == 0) {
            throw new IllegalStateException("STATE_END");
        }
        if (this._state > 0 && this._contentPosition == this._contentLength) {
            this._state = 0;
            this._handler.messageComplete(this._contentPosition);
            return total_filled;
        }
        if (this._state < 0) {
            if (this._packetLength <= 0) {
                if (this._buffer.length() < 4) {
                    if (total_filled < 0L) {
                        total_filled = 0L;
                    }
                    total_filled += (long)this.fill();
                    if (this._buffer.length() < 4) {
                        return total_filled;
                    }
                }
                this._contentLength = -3L;
                int _magic = Ajp13RequestPacket.getInt(this._buffer);
                if (_magic != 4660) {
                    throw new IOException("Bad AJP13 rcv packet: 0x" + Integer.toHexString(_magic) + " expected " + "0x" + Integer.toHexString(4660) + " " + this);
                }
                this._packetLength = Ajp13RequestPacket.getInt(this._buffer);
                if (this._packetLength > 8192) {
                    throw new IOException("AJP13 packet (" + this._packetLength + "bytes) too large for buffer");
                }
            }
            if (this._buffer.length() < this._packetLength) {
                if (total_filled < 0L) {
                    total_filled = 0L;
                }
                total_filled += (long)this.fill();
                if (this._buffer.length() < this._packetLength) {
                    return total_filled;
                }
            }
            Buffer bufHeaderName = null;
            Buffer bufHeaderValue = null;
            int attr_type = 0;
            byte packetType = Ajp13RequestPacket.getByte(this._buffer);
            switch (packetType) {
                case 2: {
                    this._handler.startForwardRequest();
                    break;
                }
                case 10: {
                    this._generator.sendCPong();
                    if (this._header != null) {
                        this._buffers.returnBuffer(this._header);
                        this._header = null;
                    }
                    if (this._body != null) {
                        this._buffers.returnBuffer(this._body);
                        this._body = null;
                    }
                    this._buffer = null;
                    this.reset(true);
                    return -1L;
                }
                case 7: {
                    this.shutdownRequest();
                    return -1L;
                }
                default: {
                    Log.warn((String)("AJP13 message type ({PING}: " + packetType + " ) not supported/recognized as an AJP request"));
                    throw new IllegalStateException("PING is not implemented");
                }
            }
            this._handler.parsedMethod(Ajp13RequestPacket.getMethod(this._buffer));
            this._handler.parsedProtocol(Ajp13RequestPacket.getString(this._buffer, this._tok0));
            this._handler.parsedUri(Ajp13RequestPacket.getString(this._buffer, this._tok1));
            this._handler.parsedRemoteAddr(Ajp13RequestPacket.getString(this._buffer, this._tok1));
            this._handler.parsedRemoteHost(Ajp13RequestPacket.getString(this._buffer, this._tok1));
            this._handler.parsedServerName(Ajp13RequestPacket.getString(this._buffer, this._tok1));
            this._handler.parsedServerPort(Ajp13RequestPacket.getInt(this._buffer));
            this._handler.parsedSslSecure(Ajp13RequestPacket.getBool(this._buffer));
            this._headers = Ajp13RequestPacket.getInt(this._buffer);
            for (int h = 0; h < this._headers; ++h) {
                bufHeaderName = Ajp13RequestPacket.getHeaderName(this._buffer, this._tok0);
                bufHeaderValue = Ajp13RequestPacket.getString(this._buffer, this._tok1);
                if (bufHeaderName != null && bufHeaderName.toString().equals("content-length")) {
                    this._contentLength = BufferUtil.toLong((Buffer)bufHeaderValue);
                    if (this._contentLength == 0L) {
                        this._contentLength = 0L;
                    }
                }
                this._handler.parsedHeader(bufHeaderName, bufHeaderValue);
            }
            attr_type = Ajp13RequestPacket.getByte(this._buffer) & 0xFF;
            while (attr_type != 255) {
                switch (attr_type) {
                    case 3: {
                        this._handler.parsedRemoteUser(Ajp13RequestPacket.getString(this._buffer, this._tok1));
                        break;
                    }
                    case 4: {
                        this._handler.parsedAuthorizationType(Ajp13RequestPacket.getString(this._buffer, this._tok1));
                        break;
                    }
                    case 5: {
                        this._handler.parsedQueryString(Ajp13RequestPacket.getString(this._buffer, this._tok1));
                        break;
                    }
                    case 6: {
                        this._handler.parsedRequestAttribute("org.eclipse.http.ajp.JVMRoute", Ajp13RequestPacket.getString(this._buffer, this._tok1));
                        break;
                    }
                    case 7: {
                        this._handler.parsedSslCert(Ajp13RequestPacket.getString(this._buffer, this._tok1));
                        break;
                    }
                    case 8: {
                        this._handler.parsedSslCipher(Ajp13RequestPacket.getString(this._buffer, this._tok1));
                        break;
                    }
                    case 9: {
                        this._handler.parsedSslSession(Ajp13RequestPacket.getString(this._buffer, this._tok1));
                        break;
                    }
                    case 10: {
                        this._handler.parsedRequestAttribute(Ajp13RequestPacket.getString(this._buffer, this._tok0).toString(), Ajp13RequestPacket.getString(this._buffer, this._tok1));
                        break;
                    }
                    case 11: {
                        int length = Ajp13RequestPacket.getInt(this._buffer);
                        if (length > 0 && length < 16) {
                            this._buffer.skip(-2);
                            this._handler.parsedSslKeySize(Integer.parseInt(Ajp13RequestPacket.getString(this._buffer, this._tok1).toString()));
                            break;
                        }
                        this._handler.parsedSslKeySize(length);
                        break;
                    }
                    case 12: {
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 1: {
                        this._handler.parsedContextPath(Ajp13RequestPacket.getString(this._buffer, this._tok1));
                        break;
                    }
                    case 2: {
                        this._handler.parsedServletPath(Ajp13RequestPacket.getString(this._buffer, this._tok1));
                        break;
                    }
                    default: {
                        Log.warn((String)"Unsupported Ajp13 Request Attribute {}", (Object)new Integer(attr_type));
                    }
                }
                attr_type = Ajp13RequestPacket.getByte(this._buffer) & 0xFF;
            }
            this._contentPosition = 0L;
            switch ((int)this._contentLength) {
                case 0: {
                    this._state = 0;
                    this._handler.headerComplete();
                    this._handler.messageComplete(this._contentPosition);
                    break;
                }
                case -3: {
                    this._generator.getBodyChunk();
                    if (this._buffers != null && this._body == null && this._buffer == this._header && this._header.length() <= 0) {
                        this._body = this._buffers.getBuffer();
                        this._body.clear();
                    }
                    this._state = 1;
                    this._handler.headerComplete();
                    return total_filled;
                }
                default: {
                    if (this._buffers != null && this._body == null && this._buffer == this._header && this._contentLength > (long)(this._header.capacity() - this._header.getIndex())) {
                        this._body = this._buffers.getBuffer();
                        this._body.clear();
                    }
                    this._state = 1;
                    this._handler.headerComplete();
                    return total_filled;
                }
            }
        }
        block30: while (this._state > 0) {
            switch (this._state) {
                case 1: {
                    int _magic;
                    if (this._buffer.length() < 6) {
                        if (total_filled < 0L) {
                            total_filled = 0L;
                        }
                        total_filled += (long)this.fill();
                        if (this._buffer.length() < 6) {
                            return total_filled;
                        }
                    }
                    if ((_magic = Ajp13RequestPacket.getInt(this._buffer)) != 4660) {
                        throw new IOException("Bad AJP13 rcv packet: 0x" + Integer.toHexString(_magic) + " expected " + "0x" + Integer.toHexString(4660) + " " + this);
                    }
                    this._chunkPosition = 0;
                    this._chunkLength = Ajp13RequestPacket.getInt(this._buffer) - 2;
                    Ajp13RequestPacket.getInt(this._buffer);
                    if (this._chunkLength == 0) {
                        this._state = 0;
                        this._generator.gotBody();
                        this._handler.messageComplete(this._contentPosition);
                        return total_filled;
                    }
                    this._state = 2;
                    continue block30;
                }
                case 2: {
                    int remaining;
                    if (this._buffer.length() < this._chunkLength) {
                        if (total_filled < 0L) {
                            total_filled = 0L;
                        }
                        total_filled += (long)this.fill();
                        if (this._buffer.length() < this._chunkLength) {
                            return total_filled;
                        }
                    }
                    if ((remaining = this._chunkLength - this._chunkPosition) == 0) {
                        this._state = 1;
                        if (this._contentPosition < this._contentLength) {
                            this._generator.getBodyChunk();
                        } else {
                            this._generator.gotBody();
                        }
                        return total_filled;
                    }
                    if (this._buffer.length() < remaining) {
                        remaining = this._buffer.length();
                    }
                    Buffer chunk = Ajp13RequestPacket.get(this._buffer, remaining);
                    this._contentPosition += (long)chunk.length();
                    this._chunkPosition += chunk.length();
                    this._contentView.update(chunk);
                    remaining = this._chunkLength - this._chunkPosition;
                    if (remaining == 0) {
                        this._state = 1;
                        if (this._contentPosition < this._contentLength || this._contentLength == -3L) {
                            this._generator.getBodyChunk();
                        } else {
                            this._generator.gotBody();
                        }
                    }
                    this._handler.content(chunk);
                    return total_filled;
                }
            }
            throw new IllegalStateException("Invalid Content State");
        }
        return total_filled;
    }

    public void reset(boolean returnBuffers) {
        this._state = -1;
        this._contentLength = -3L;
        this._contentPosition = 0L;
        this._length = 0;
        this._packetLength = 0;
        if (this._body != null) {
            if (this._body.hasContent()) {
                this._header.setMarkIndex(-1);
                this._header.compact();
                this._body.skip(this._header.put(this._body));
            }
            if (this._body.length() == 0) {
                if (this._buffers != null && returnBuffers) {
                    this._buffers.returnBuffer(this._body);
                }
                this._body = null;
            } else {
                this._body.setMarkIndex(-1);
                this._body.compact();
            }
        }
        if (this._header != null) {
            this._header.setMarkIndex(-1);
            if (!this._header.hasContent() && this._buffers != null && returnBuffers) {
                this._buffers.returnBuffer(this._header);
                this._header = null;
                this._buffer = null;
            } else {
                this._header.compact();
                this._tok0.update(this._header);
                this._tok0.update(0, 0);
                this._tok1.update(this._header);
                this._tok1.update(0, 0);
            }
        }
        this._buffer = this._header;
    }

    Buffer getHeaderBuffer() {
        return this._buffer;
    }

    private void shutdownRequest() {
        this._state = 0;
        if (!Ajp13SocketConnector.__allowShutdown) {
            Log.warn((String)"AJP13: Shutdown Request is Denied, allowShutdown is set to false!!!");
            return;
        }
        if (Ajp13SocketConnector.__secretWord != null) {
            Log.warn((String)"AJP13: Validating Secret Word");
            try {
                String secretWord = Ajp13RequestPacket.getString(this._buffer, this._tok1).toString();
                if (!Ajp13SocketConnector.__secretWord.equals(secretWord)) {
                    Log.warn((String)"AJP13: Shutdown Request Denied, Invalid Sercret word!!!");
                    throw new IllegalStateException("AJP13: Secret Word is Invalid: Peer has requested shutdown but, Secret Word did not match");
                }
            }
            catch (Exception e) {
                Log.warn((String)"AJP13: Secret Word is Required!!!");
                Log.debug((Throwable)e);
                throw new IllegalStateException("AJP13: Secret Word is Required: Peer has requested shutdown but, has not provided a Secret Word");
            }
            Log.warn((String)"AJP13: Shutdown Request is Denied, allowShutdown is set to false!!!");
            return;
        }
        Log.warn((String)"AJP13: Peer Has Requested for Shutdown!!!");
        Log.warn((String)"AJP13: Jetty 6 is shutting down !!!");
        System.exit(0);
    }

    public static class Input
    extends ServletInputStream {
        private Ajp13Parser _parser;
        private EndPoint _endp;
        private long _maxIdleTime;
        private View _content;

        public Input(Ajp13Parser parser, long maxIdleTime) {
            this._parser = parser;
            this._endp = parser._endp;
            this._maxIdleTime = maxIdleTime;
            this._content = this._parser._contentView;
        }

        public int read() throws IOException {
            int c = -1;
            if (this.blockForContent()) {
                c = 0xFF & this._content.get();
            }
            return c;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int l = -1;
            if (this.blockForContent()) {
                l = this._content.get(b, off, len);
            }
            return l;
        }

        private boolean blockForContent() throws IOException {
            if (this._content.length() > 0) {
                return true;
            }
            if (this._parser.isState(0) || this._parser.isState(-1)) {
                return false;
            }
            if (this._endp == null) {
                this._parser.parseNext();
            } else if (this._endp.isBlocking()) {
                this._parser.parseNext();
                while (this._content.length() == 0 && !this._parser.isState(0)) {
                    this._parser.parseNext();
                }
            } else {
                long filled = this._parser.parseNext();
                boolean blocked = false;
                while (this._content.length() == 0 && !this._parser.isState(0)) {
                    if (filled > 0L) {
                        blocked = false;
                    } else if (filled == 0L) {
                        if (blocked) {
                            throw new InterruptedIOException("timeout");
                        }
                        blocked = true;
                        this._endp.blockReadable(this._maxIdleTime);
                    }
                    filled = this._parser.parseNext();
                }
            }
            return this._content.length() > 0;
        }
    }

    public static interface EventHandler {
        public void content(Buffer var1) throws IOException;

        public void headerComplete() throws IOException;

        public void messageComplete(long var1) throws IOException;

        public void parsedHeader(Buffer var1, Buffer var2) throws IOException;

        public void parsedMethod(Buffer var1) throws IOException;

        public void parsedProtocol(Buffer var1) throws IOException;

        public void parsedQueryString(Buffer var1) throws IOException;

        public void parsedRemoteAddr(Buffer var1) throws IOException;

        public void parsedRemoteHost(Buffer var1) throws IOException;

        public void parsedRequestAttribute(String var1, Buffer var2) throws IOException;

        public void parsedRequestAttribute(String var1, int var2) throws IOException;

        public void parsedServerName(Buffer var1) throws IOException;

        public void parsedServerPort(int var1) throws IOException;

        public void parsedSslSecure(boolean var1) throws IOException;

        public void parsedUri(Buffer var1) throws IOException;

        public void startForwardRequest() throws IOException;

        public void parsedAuthorizationType(Buffer var1) throws IOException;

        public void parsedRemoteUser(Buffer var1) throws IOException;

        public void parsedServletPath(Buffer var1) throws IOException;

        public void parsedContextPath(Buffer var1) throws IOException;

        public void parsedSslCert(Buffer var1) throws IOException;

        public void parsedSslCipher(Buffer var1) throws IOException;

        public void parsedSslSession(Buffer var1) throws IOException;

        public void parsedSslKeySize(int var1) throws IOException;
    }
}

