/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.parser;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jxls.parser.Aggregator;
import net.sf.jxls.parser.ExpressionCollectionParser;
import net.sf.jxls.parser.Property;
import net.sf.jxls.transformer.Configuration;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;

public class Expression {
    public static final String aggregateSeparator = "[a-zA-Z()]+[0-9]*:";
    private static final JexlEngine jexlEngine = new JexlEngine();
    String expression;
    String rawExpression;
    String aggregateFunction;
    String aggregateField;
    Map beans;
    List properties = new ArrayList();
    org.apache.commons.jexl2.Expression jexlExpresssion;
    Configuration config;
    Property collectionProperty;

    public Property getCollectionProperty() {
        return this.collectionProperty;
    }

    public List getProperties() {
        return this.properties;
    }

    public String getExpression() {
        return this.expression;
    }

    public Expression(String expression, Configuration config) {
        this.expression = expression;
        this.config = config;
    }

    public Expression(String expression, Map beans, Configuration config) throws Exception {
        this.config = config;
        this.expression = expression;
        this.rawExpression = this.parseAggregate(expression);
        this.beans = beans;
        this.jexlExpresssion = ExpressionCollectionParser.expressionCache.get(this.rawExpression);
        if (this.jexlExpresssion == null) {
            this.jexlExpresssion = jexlEngine.createExpression(this.rawExpression);
            ExpressionCollectionParser.expressionCache.put(this.rawExpression, this.jexlExpresssion);
        }
        this.parse();
    }

    public Object evaluate() throws Exception {
        if (this.beans != null && !this.beans.isEmpty()) {
            MapContext context = new MapContext(this.beans);
            Object ret = this.jexlExpresssion.evaluate((JexlContext)context);
            if (this.aggregateFunction != null) {
                return this.calculateAggregate(this.aggregateFunction, this.aggregateField, ret);
            }
            return ret;
        }
        return this.expression;
    }

    private String parseAggregate(String expr) {
        String[] aggregateParts = expr.split(aggregateSeparator, 2);
        int i = expr.indexOf(":");
        if (aggregateParts.length >= 2 && i >= 0) {
            String aggregate = expr.substring(0, i);
            if (aggregate.length() == 0) {
                this.aggregateFunction = null;
                this.aggregateField = null;
            } else {
                int f1 = aggregate.indexOf("(");
                int f2 = aggregate.indexOf(")");
                if (f1 != -1 && f2 != -1 && f2 > f1) {
                    this.aggregateFunction = aggregate.substring(0, f1);
                    this.aggregateField = aggregate.substring(f1 + 1, f2);
                } else {
                    this.aggregateFunction = aggregate;
                    this.aggregateField = "c1";
                }
            }
            return expr.substring(i + 1);
        }
        this.aggregateFunction = null;
        this.aggregateField = null;
        return expr;
    }

    private void parse() {
        Property prop = new Property(this.rawExpression, this.beans, this.config);
        this.properties = new ArrayList();
        this.properties.add(prop);
        if (prop.isCollection() && this.aggregateFunction == null && this.collectionProperty == null) {
            this.collectionProperty = prop;
        }
    }

    private Object calculateAggregate(String function, String field, Object list) {
        Aggregator agg = Aggregator.getInstance(function);
        if (agg != null) {
            if (list instanceof Collection) {
                Collection coll = (Collection)list;
                for (Object o : coll) {
                    try {
                        Object f = PropertyUtils.getProperty(o, (String)field);
                        agg.add(f);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    Object f = PropertyUtils.getProperty((Object)list, (String)field);
                    agg.add(f);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return agg.getResult();
        }
        return list;
    }

    public String toString() {
        return this.expression;
    }

    static {
        jexlEngine.setDebug(false);
    }
}

