/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.util;

import java.util.ArrayList;
import java.util.List;
import net.sf.jxls.formula.Formula;
import net.sf.jxls.parser.CellParser;
import net.sf.jxls.tag.Block;
import net.sf.jxls.transformer.Row;
import net.sf.jxls.transformer.Sheet;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;

public class SheetHelper {
    public static List findFormulas(Sheet sheet) {
        return SheetHelper.findFormulas(sheet, new Block(null, 0, sheet.getHssfSheet().getLastRowNum()));
    }

    public static List findFormulas(Sheet sheet, Block block) {
        ArrayList formulas = new ArrayList();
        for (int i = block.getStartRowNum(); i <= block.getEndRowNum(); ++i) {
            HSSFRow hssfRow = sheet.getHssfSheet().getRow(i);
            if (block.isRowBlock()) {
                formulas.addAll(SheetHelper.findFormulasInRow(sheet, hssfRow));
                continue;
            }
            formulas.addAll(SheetHelper.findFormulasInRow(sheet, hssfRow, block.getStartCellNum(), block.getEndCellNum()));
        }
        return formulas;
    }

    private static List findFormulasInRow(Sheet sheet, HSSFRow hssfRow, short startCellNum, short endCellNum) {
        ArrayList<Formula> formulas = new ArrayList<Formula>();
        if (hssfRow != null) {
            Row row = new Row(sheet, hssfRow);
            short endNum = (short)Math.min(hssfRow.getLastCellNum(), endCellNum);
            for (short i = (short)Math.max(hssfRow.getFirstCellNum(), startCellNum); i <= endNum; i = (short)(i + 1)) {
                CellParser cellParser;
                HSSFCell hssfCell = hssfRow.getCell(i);
                if (hssfCell == null || (cellParser = new CellParser(hssfCell, row, sheet.getConfiguration())).parseCellFormula() == null || cellParser.getCell().getFormula().isInline()) continue;
                Formula formula = cellParser.getCell().getFormula();
                formula.setSheet(sheet);
                formulas.add(formula);
            }
        }
        return formulas;
    }

    private static List findFormulasInRow(Sheet sheet, HSSFRow hssfRow) {
        ArrayList<Formula> formulas = new ArrayList<Formula>();
        if (hssfRow != null) {
            Row row = new Row(sheet, hssfRow);
            for (short i = hssfRow.getFirstCellNum(); i <= hssfRow.getLastCellNum(); i = (short)(i + 1)) {
                CellParser cellParser;
                HSSFCell hssfCell = hssfRow.getCell(i);
                if (hssfCell == null || (cellParser = new CellParser(hssfCell, row, sheet.getConfiguration())).parseCellFormula() == null || cellParser.getCell().getFormula().isInline()) continue;
                Formula formula = cellParser.getCell().getFormula();
                formula.setSheet(sheet);
                formulas.add(formula);
            }
        }
        return formulas;
    }
}

