/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformer;

import java.util.ArrayList;
import java.util.List;
import net.sf.jxls.parser.Cell;
import net.sf.jxls.parser.Property;
import net.sf.jxls.transformer.MergedRegion;
import net.sf.jxls.transformer.RowCollection;
import net.sf.jxls.transformer.Sheet;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.util.Region;

public class Row {
    private HSSFRow hssfRow;
    private Sheet sheet;
    private List cells = new ArrayList();
    private List rowCollections = new ArrayList();
    private List mergedRegions = new ArrayList();
    private Row parentRow;

    public Row getParentRow() {
        return this.parentRow;
    }

    public void setParentRow(Row parentRow) {
        this.parentRow = parentRow;
    }

    public Row(Sheet sheet, HSSFRow hssfRow) {
        this.sheet = sheet;
        this.hssfRow = hssfRow;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public RowCollection getMaxNumberOfRowsCollection() {
        if (this.rowCollections.size() == 0) {
            return null;
        }
        RowCollection maxNumberOfRowsCollection = (RowCollection)this.rowCollections.get(0);
        for (int i = 1; i < this.rowCollections.size(); ++i) {
            RowCollection rowCollection = (RowCollection)this.rowCollections.get(i);
            if (rowCollection.getNumberOfRows() <= maxNumberOfRowsCollection.getNumberOfRows()) continue;
            maxNumberOfRowsCollection = rowCollection;
        }
        return maxNumberOfRowsCollection;
    }

    public RowCollection getMaxSizeCollection() {
        if (this.rowCollections.size() == 0) {
            return null;
        }
        RowCollection maxSizeRowCollection = (RowCollection)this.rowCollections.get(0);
        for (int i = 1; i < this.rowCollections.size(); ++i) {
            RowCollection rowCollection = (RowCollection)this.rowCollections.get(i);
            if (rowCollection.getCollectionProperty().getCollection().size() <= maxSizeRowCollection.getCollectionProperty().getCollection().size()) continue;
            maxSizeRowCollection = rowCollection;
        }
        return maxSizeRowCollection;
    }

    public RowCollection getRowCollectionByCollectionName(String collectionName) {
        for (int i = 0; i < this.rowCollections.size(); ++i) {
            RowCollection rowCollection = (RowCollection)this.rowCollections.get(i);
            if (!rowCollection.getCollectionProperty().getFullCollectionName().equals(collectionName)) continue;
            return rowCollection;
        }
        return null;
    }

    public List getRowCollections() {
        return this.rowCollections;
    }

    private RowCollection getRowCollection(Property collectionProperty, int dependentRowNumber) {
        for (int i = 0; i < this.rowCollections.size(); ++i) {
            RowCollection rowCollection = (RowCollection)this.rowCollections.get(i);
            if (!rowCollection.getCollectionProperty().getFullCollectionName().equals(collectionProperty.getFullCollectionName())) continue;
            return rowCollection;
        }
        RowCollection rowCollection = new RowCollection(this, collectionProperty, dependentRowNumber);
        this.rowCollections.add(rowCollection);
        return rowCollection;
    }

    public void addRowCollection(RowCollection rowCollection) {
        this.rowCollections.add(rowCollection);
    }

    private void addMergedRegion(MergedRegion mergedRegion) {
        this.mergedRegions.add(mergedRegion);
    }

    public RowCollection addCell(Cell cell) {
        RowCollection rowCollection = null;
        this.cells.add(cell);
        if (cell.getCollectionProperty() != null) {
            rowCollection = this.getRowCollection(cell.getCollectionProperty(), cell.getDependentRowNumber());
            rowCollection.addCell(cell);
            if (cell.getMergedRegion() != null) {
                MergedRegion mergedRegion = new MergedRegion(cell.getMergedRegion(), rowCollection);
                this.addMergedRegion(mergedRegion);
            }
        } else if (cell.getMergedRegion() != null && cell.isEmpty() && (rowCollection = this.getRowCollection(cell.getMergedRegion())) != null) {
            rowCollection.addCell(cell);
        }
        return rowCollection;
    }

    private RowCollection getRowCollection(Region mergedRegion) {
        for (int i = 0; i < this.mergedRegions.size(); ++i) {
            MergedRegion region = (MergedRegion)this.mergedRegions.get(i);
            if (!region.getRegion().equals(mergedRegion)) continue;
            return region.getRowCollection();
        }
        return null;
    }

    public List getCells() {
        return this.cells;
    }

    public void setCells(List cells) {
        this.cells = cells;
    }

    public HSSFRow getHssfRow() {
        return this.hssfRow;
    }

    public void setHssfRow(HSSFRow hssfRow) {
        this.hssfRow = hssfRow;
    }

    public int getMinDependentRowNumber() {
        if (this.rowCollections.size() == 0) {
            return 0;
        }
        int minDependentRowNumber = ((RowCollection)this.rowCollections.get(0)).getDependentRowNumber();
        for (int i = 1; i < this.rowCollections.size(); ++i) {
            RowCollection rowCollection = (RowCollection)this.rowCollections.get(i);
            if (rowCollection.getDependentRowNumber() >= minDependentRowNumber) continue;
            minDependentRowNumber = rowCollection.getDependentRowNumber();
        }
        return minDependentRowNumber;
    }
}

