/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformation;

import net.sf.jxls.tag.Block;
import net.sf.jxls.transformation.BaseTransformation;

public class ResultTransformation
extends BaseTransformation {
    int lastRowShift;
    int nextRowShift;
    short nextCellShift;
    short lastCellShift;
    int lastProcessedRow = -1;
    boolean isTagProcessResult;

    public ResultTransformation() {
    }

    public ResultTransformation(short nextCellShift, short lastCellShift) {
        this.nextCellShift = nextCellShift;
        this.lastCellShift = lastCellShift;
    }

    public ResultTransformation(int nextRowShift) {
        this.nextRowShift = nextRowShift;
    }

    public ResultTransformation(int nextRowShift, int lastRowShift) {
        this.nextRowShift = nextRowShift;
        this.lastRowShift = lastRowShift;
    }

    public boolean isTagProcessResult() {
        return this.isTagProcessResult;
    }

    public void setTagProcessResult(boolean tagProcessResult) {
        this.isTagProcessResult = tagProcessResult;
    }

    public int getLastProcessedRow() {
        return this.lastProcessedRow;
    }

    public void setLastProcessedRow(int lastProcessedRow) {
        this.lastProcessedRow = lastProcessedRow;
    }

    public ResultTransformation add(ResultTransformation transformation) {
        this.lastRowShift += transformation.getLastRowShift();
        this.nextRowShift += transformation.getNextRowShift();
        this.lastCellShift = (short)(this.lastCellShift + transformation.getLastCellShift());
        this.nextCellShift = (short)(this.nextCellShift + transformation.getNextCellShift());
        if (transformation.getLastProcessedRow() >= 0) {
            this.lastProcessedRow = Math.max(this.lastProcessedRow, transformation.getLastProcessedRow());
        }
        this.isTagProcessResult = this.isTagProcessResult || transformation.isTagProcessResult();
        return this;
    }

    public Block transformBlock(Block block) {
        if (block != null) {
            block = block.horizontalShift(this.lastCellShift);
            block = block.verticalShift(this.lastRowShift);
        }
        return block;
    }

    public ResultTransformation addNextRowShift(int shift) {
        this.nextRowShift += shift;
        return this;
    }

    public ResultTransformation addRightShift(short shift) {
        this.lastCellShift = (short)(this.lastCellShift + shift);
        return this;
    }

    public short getLastCellShift() {
        return this.lastCellShift;
    }

    public int getLastRowShift() {
        return this.lastRowShift;
    }

    public void setLastRowShift(int lastRowShift) {
        this.lastRowShift = lastRowShift;
    }

    public int getNextRowShift() {
        return this.nextRowShift;
    }

    public void setNextRowShift(int nextRowShift) {
        this.nextRowShift = nextRowShift;
    }

    public short getNextCellShift() {
        return this.nextCellShift;
    }
}

