/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformation;

import java.util.ArrayList;
import java.util.List;
import net.sf.jxls.formula.CellRef;
import net.sf.jxls.tag.Block;
import net.sf.jxls.tag.Point;
import net.sf.jxls.transformation.BlockTransformation;
import org.apache.poi.hssf.util.CellReference;

public class DuplicateTransformation
extends BlockTransformation {
    int rowNum;
    int colNum;
    int duplicateNumber;
    List cells = new ArrayList();

    public DuplicateTransformation(Block block, int duplicateNumber) {
        super(block);
        this.duplicateNumber = duplicateNumber;
    }

    public Block getBlockAfterTransformation() {
        return null;
    }

    public List transformCell(Point p) {
        ArrayList<Point> resultCells;
        if (this.block.contains(p)) {
            resultCells = new ArrayList<Point>();
            Point rp = p;
            resultCells.add(p);
            for (int i = 0; i < this.duplicateNumber; ++i) {
                rp = rp.shift(this.block.getNumberOfRows(), 0);
                resultCells.add(rp);
            }
        } else {
            resultCells = new ArrayList();
            resultCells.add(p);
        }
        return resultCells;
    }

    public String getDuplicatedCellRef(String sheetName, String cell, int duplicateBlock) {
        CellReference cellRef = new CellReference(cell);
        int row = cellRef.getRow();
        short col = cellRef.getCol();
        String refSheetName = cellRef.getSheetName();
        String resultCellRef = cell;
        if ((this.block.getSheet().getSheetName().equalsIgnoreCase(refSheetName) || refSheetName == null && this.block.getSheet().getSheetName().equalsIgnoreCase(sheetName)) && this.block.contains(row, col) && this.duplicateNumber >= 1 && this.duplicateNumber >= duplicateBlock) {
            resultCellRef = this.cellToString(row += this.block.getNumberOfRows() * duplicateBlock, col, refSheetName);
        }
        return resultCellRef;
    }

    public List transformCell(String sheetName, CellRef cellRef) {
        String refSheetName = cellRef.getSheetName();
        this.cells.clear();
        if ((this.block.getSheet().getSheetName().equalsIgnoreCase(refSheetName) || refSheetName == null && this.block.getSheet().getSheetName().equalsIgnoreCase(sheetName)) && this.block.contains(cellRef.getRowNum(), cellRef.getColNum())) {
            this.rowNum = cellRef.getRowNum();
            if (cellRef.getCellIndex() == null) {
                this.cells.add(this.cellToString(this.rowNum, cellRef.getColNum(), refSheetName));
                for (int i = 0; i < this.duplicateNumber; ++i) {
                    this.rowNum += this.block.getNumberOfRows();
                    this.cells.add(this.cellToString(this.rowNum, cellRef.getColNum(), refSheetName));
                }
            } else {
                this.rowNum += this.block.getNumberOfRows() * cellRef.getCellIndex();
                this.cells.add(this.cellToString(this.rowNum, cellRef.getColNum(), refSheetName));
            }
        }
        return this.cells;
    }

    public String cellToString(int row, int col, String sheetName) {
        CellReference cellReference = new CellReference(row, col);
        String cellname = sheetName != null ? sheetName + "!" + cellReference.toString() : cellReference.toString();
        return cellname;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DuplicateTransformation) {
            DuplicateTransformation dt = (DuplicateTransformation)obj;
            return super.equals(obj) && dt.duplicateNumber == this.duplicateNumber;
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.duplicateNumber;
        return result;
    }

    public String toString() {
        return "DuplicateTransformation: {" + super.toString() + ", duplicateNumber=" + this.duplicateNumber + "}";
    }
}

