/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.tag;

import java.util.HashSet;
import java.util.Set;
import net.sf.jxls.formula.CellRef;
import net.sf.jxls.formula.Formula;
import net.sf.jxls.tag.Point;
import net.sf.jxls.transformer.Sheet;

public class Block {
    int startRowNum;
    int endRowNum;
    short startCellNum;
    short endCellNum;
    Sheet sheet;
    Set affectedColumns = new HashSet();

    public Block(Sheet sheet, int startRowNum, int endRowNum) {
        this.startRowNum = startRowNum;
        this.endRowNum = endRowNum;
        this.startCellNum = (short)-1;
        this.endCellNum = (short)-1;
        this.sheet = sheet;
    }

    public Block(int startRowNum, short startCellNum, int endRowNum, short endCellNum) {
        this.startRowNum = startRowNum;
        this.startCellNum = startCellNum;
        this.endRowNum = endRowNum;
        this.endCellNum = endCellNum;
    }

    public Block(Sheet sheet, int startRowNum, short startCellNum, int endRowNum, short endCellNum) {
        this.sheet = sheet;
        this.startRowNum = startRowNum;
        this.startCellNum = startCellNum;
        this.endRowNum = endRowNum;
        this.endCellNum = endCellNum;
    }

    public void addAffectedColumn(short col) {
        this.affectedColumns.add(new Short(col));
    }

    public Block horizontalShift(short cellShift) {
        this.startCellNum = (short)(this.startCellNum + cellShift);
        this.endCellNum = (short)(this.endCellNum + cellShift);
        return this;
    }

    public Block verticalShift(int rowShift) {
        this.startRowNum += rowShift;
        this.endRowNum += rowShift;
        return this;
    }

    public short getStartCellNum() {
        return this.startCellNum;
    }

    public void setStartCellNum(short startCellNum) {
        this.startCellNum = startCellNum;
    }

    public short getEndCellNum() {
        return this.endCellNum;
    }

    public void setEndCellNum(short endCellNum) {
        this.endCellNum = endCellNum;
    }

    public int getStartRowNum() {
        return this.startRowNum;
    }

    public void setStartRowNum(int startRowNum) {
        this.startRowNum = startRowNum;
    }

    public int getEndRowNum() {
        return this.endRowNum;
    }

    public void setEndRowNum(int endRowNum) {
        this.endRowNum = endRowNum;
    }

    public int getNumberOfRows() {
        return this.endRowNum - this.startRowNum + 1;
    }

    public int getNumberOfColumns() {
        return this.endCellNum - this.startCellNum + 1;
    }

    public boolean contains(int rowNum, int cellNum) {
        boolean flag;
        boolean bl = flag = this.startRowNum <= rowNum && rowNum <= this.endRowNum && (this.startCellNum < 0 || this.endCellNum < 0 || this.startCellNum <= cellNum && cellNum <= this.endCellNum);
        if (flag && !this.affectedColumns.isEmpty()) {
            return this.affectedColumns.contains(new Short((short)cellNum));
        }
        return flag;
    }

    public boolean contains(Formula formula) {
        if (formula.getSheet().getSheetName().equals(this.sheet.getSheetName())) {
            return this.contains(formula.getRowNum(), formula.getCellNum());
        }
        return false;
    }

    public boolean contains(Point p) {
        boolean flag;
        boolean bl = flag = this.startRowNum <= p.getRow() && p.getRow() <= this.endRowNum && (this.startCellNum < 0 || this.endCellNum < 0 || this.startCellNum <= p.getCol() && p.getCol() <= this.endCellNum);
        if (flag && !this.affectedColumns.isEmpty()) {
            return this.affectedColumns.contains(new Short(p.getCol()));
        }
        return flag;
    }

    public boolean contains(CellRef cellRef) {
        boolean flag;
        String refSheetName = cellRef.getSheetName();
        boolean bl = flag = (refSheetName == null || this.sheet.getSheetName().equals(refSheetName)) && this.startRowNum <= cellRef.getRowNum() && cellRef.getRowNum() <= this.endRowNum && (this.startCellNum < 0 || this.endCellNum < 0 || this.startCellNum <= cellRef.getColNum() && cellRef.getColNum() <= this.endCellNum);
        if (flag && !this.affectedColumns.isEmpty()) {
            return this.affectedColumns.contains(new Short(cellRef.getColNum()));
        }
        return flag;
    }

    public boolean isAbove(Point p) {
        return this.endRowNum < p.getRow();
    }

    public boolean isToLeft(Point p) {
        return this.endCellNum < p.getCol();
    }

    public boolean isAbove(int rowNum) {
        return this.endRowNum < rowNum;
    }

    public boolean isBelow(Point p) {
        return this.startRowNum > p.getRow();
    }

    public boolean isRowBlock() {
        return this.startCellNum < 0 || this.endCellNum < 0 || this.startCellNum > this.endCellNum;
    }

    public boolean isColBlock() {
        return this.startRowNum < 0 || this.endRowNum < 0 || this.startRowNum > this.endRowNum;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        if (this.endCellNum != block.endCellNum) {
            return false;
        }
        if (this.endRowNum != block.endRowNum) {
            return false;
        }
        if (this.startCellNum != block.startCellNum) {
            return false;
        }
        if (this.startRowNum != block.startRowNum) {
            return false;
        }
        return !(this.sheet == null ? block.sheet != null : !this.sheet.equals(block.sheet));
    }

    public int hashCode() {
        int result = this.startRowNum;
        result = 29 * result + this.endRowNum;
        result = 29 * result + this.startCellNum;
        result = 29 * result + this.endCellNum;
        result = 29 * result + (this.sheet != null ? this.sheet.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Block (" + this.startRowNum + ", " + this.startCellNum + ", " + this.endRowNum + ", " + this.endCellNum + ")";
    }
}

