/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.util;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.jxls.parser.Cell;
import org.jxls.transformer.Row;
import org.jxls.transformer.RowCollection;

public final class Util {
    protected static Log log = LogFactory.getLog((Class)(class$org$jxls$util$Util == null ? (class$org$jxls$util$Util = Util.class$("org.jxls.util.Util")) : class$org$jxls$util$Util));
    private static final String[][] ENTITY_ARRAY = new String[][]{{"quot", "34"}, {"amp", "38"}, {"lt", "60"}, {"gt", "62"}, {"apos", "39"}};
    private static Map xmlEntities = new HashMap();
    static /* synthetic */ Class class$org$jxls$util$Util;

    public static void removeRowCollectionPropertiesFromRow(RowCollection rowCollection) {
        int startRow = rowCollection.getParentRow().getHssfRow().getRowNum();
        HSSFSheet sheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        for (int i = 0; i <= rowCollection.getDependentRowNumber(); ++i) {
            HSSFRow hssfRow = sheet.getRow(startRow + i);
            for (short j = hssfRow.getFirstCellNum(); j <= hssfRow.getLastCellNum(); j = (short)(j + 1)) {
                HSSFCell cell = hssfRow.getCell(j);
                Util.removeRowCollectionPropertyFromCell(cell, rowCollection.getCollectionProperty().getFullCollectionName());
            }
        }
    }

    private static void removeRowCollectionPropertyFromCell(HSSFCell cell, String collectionName) {
        String regex = "[-+*/().A-Za-z_0-9\\s]*";
        if (cell != null && cell.getCellType() == 1) {
            String cellValue = cell.getStringCellValue();
            String strToReplace = "\\$\\{" + regex + collectionName.replaceAll("\\.", "\\\\.") + "\\." + regex + "\\}";
            cell.setCellValue(cellValue.replaceAll(strToReplace, ""));
        }
    }

    private static void removeMergedRegion(HSSFSheet sheet, Region region) {
        int index = Util.getMergedRegionIndex(sheet, region);
        sheet.removeMergedRegion(index);
    }

    private static int getMergedRegionIndex(HSSFSheet sheet, Region mergedRegion) {
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            Region region = sheet.getMergedRegionAt(i);
            if (!region.equals(mergedRegion)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isNewMergedRegion(Region region, Collection mergedRegions) {
        return !mergedRegions.contains(region);
    }

    public static Region getMergedRegion(HSSFSheet sheet, int rowNum, short cellNum) {
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            Region merged = sheet.getMergedRegionAt(i);
            if (!merged.contains(rowNum, cellNum)) continue;
            return merged;
        }
        return null;
    }

    public static boolean removeMergedRegion(HSSFSheet sheet, int rowNum, short cellNum) {
        TreeSet<Integer> mergedRegionNumbersToRemove = new TreeSet<Integer>();
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            Region merged = sheet.getMergedRegionAt(i);
            if (!merged.contains(rowNum, cellNum)) continue;
            mergedRegionNumbersToRemove.add(new Integer(i));
        }
        Iterator iterator = mergedRegionNumbersToRemove.iterator();
        while (iterator.hasNext()) {
            Integer regionNumber = (Integer)iterator.next();
            sheet.removeMergedRegion(regionNumber.intValue());
        }
        return !mergedRegionNumbersToRemove.isEmpty();
    }

    public static void prepareCollectionPropertyInRowForDuplication(RowCollection rowCollection, String collectionItemName) {
        int startRow = rowCollection.getParentRow().getHssfRow().getRowNum();
        HSSFSheet sheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        for (int i = 0; i <= rowCollection.getDependentRowNumber(); ++i) {
            HSSFRow hssfRow = sheet.getRow(startRow + i);
            for (short j = hssfRow.getFirstCellNum(); j <= hssfRow.getLastCellNum(); j = (short)(j + 1)) {
                HSSFCell cell = hssfRow.getCell(j);
                Util.prepareCollectionPropertyInCellForDuplication(cell, rowCollection.getCollectionProperty().getFullCollectionName(), collectionItemName);
            }
        }
    }

    private static void prepareCollectionPropertyInCellForDuplication(HSSFCell cell, String collectionName, String collectionItemName) {
        if (cell != null && cell.getCellType() == 1) {
            String cellValue = cell.getStringCellValue();
            String newValue = cellValue.replaceAll(collectionName, collectionItemName);
            cell.setCellValue(newValue);
        }
    }

    public static void prepareCollectionPropertyInRowForContentDuplication(RowCollection rowCollection) {
        for (int i = 0; i < rowCollection.getCells().size(); ++i) {
            Cell cell = (Cell)rowCollection.getCells().get(i);
            Util.prepareCollectionPropertyInCellForDuplication(cell.getHssfCell(), rowCollection.getCollectionProperty().getFullCollectionName(), rowCollection.getCollectionItemName());
        }
    }

    public static void duplicateRowCollectionProperty(RowCollection rowCollection) {
        Collection collection = rowCollection.getCollectionProperty().getCollection();
        int rowNum = rowCollection.getParentRow().getHssfRow().getRowNum();
        HSSFRow srcRow = rowCollection.getParentRow().getHssfRow();
        HSSFSheet sheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        if (collection.size() > 1) {
            for (int i = 1; i < collection.size(); ++i) {
                HSSFRow destRow = sheet.getRow(rowNum + i);
                for (int j = 0; j < rowCollection.getCells().size(); ++j) {
                    Cell cell = (Cell)rowCollection.getCells().get(j);
                    if (cell.isEmpty()) continue;
                    HSSFCell destCell = destRow.getCell(cell.getHssfCell().getCellNum());
                    if (destCell == null) {
                        destCell = destRow.createCell(cell.getHssfCell().getCellNum());
                    }
                    Util.copyCell(srcRow.getCell(cell.getHssfCell().getCellNum()), destCell, false);
                }
            }
        }
    }

    public static int duplicateRow(RowCollection rowCollection) {
        Collection collection = rowCollection.getCollectionProperty().getCollection();
        int row = rowCollection.getParentRow().getHssfRow().getRowNum();
        HSSFSheet sheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        if (collection.size() > 1) {
            if (rowCollection.getDependentRowNumber() == 0) {
                sheet.shiftRows(row + 1, sheet.getLastRowNum(), collection.size() - 1, true, false);
                Util.duplicateStyle(rowCollection, row, row + 1, collection.size() - 1);
                Util.shiftUncoupledCellsUp(rowCollection);
            } else {
                for (int i = 0; i < collection.size() - 1; ++i) {
                    Util.shiftCopyRowCollection(rowCollection);
                }
                Util.shiftUncoupledCellsUp(rowCollection);
            }
        }
        return (collection.size() - 1) * (rowCollection.getDependentRowNumber() + 1);
    }

    private static void shiftCopyRowCollection(RowCollection rowCollection) {
        HSSFSheet hssfSheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        int startRow = rowCollection.getParentRow().getHssfRow().getRowNum();
        int num = rowCollection.getDependentRowNumber();
        hssfSheet.shiftRows(startRow + num + 1, hssfSheet.getLastRowNum(), num + 1, true, false);
        Util.copyRowCollection(rowCollection);
    }

    private static void copyRowCollection(RowCollection rowCollection) {
        HSSFSheet sheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        int from = rowCollection.getParentRow().getHssfRow().getRowNum();
        int num = rowCollection.getDependentRowNumber() + 1;
        int to = from + num;
        TreeSet<Region> mergedRegions = new TreeSet<Region>();
        for (int i = from; i < from + num; ++i) {
            HSSFRow srcRow = sheet.getRow(i);
            HSSFRow destRow = sheet.getRow(to + i - from);
            if (destRow == null) {
                destRow = sheet.createRow(to + i - from);
            }
            destRow.setHeight(srcRow.getHeight());
            for (short j = srcRow.getFirstCellNum(); j <= srcRow.getLastCellNum(); j = (short)(j + 1)) {
                Region newMergedRegion;
                HSSFCell srcCell = srcRow.getCell(j);
                if (srcCell == null) continue;
                HSSFCell destCell = destRow.createCell(j);
                Util.copyCell(srcCell, destCell, true);
                Region mergedRegion = Util.getMergedRegion(sheet, i, j);
                if (mergedRegion == null || !Util.isNewMergedRegion(newMergedRegion = new Region(to - from + mergedRegion.getRowFrom(), mergedRegion.getColumnFrom(), to - from + mergedRegion.getRowTo(), mergedRegion.getColumnTo()), mergedRegions)) continue;
                mergedRegions.add(newMergedRegion);
            }
        }
        Iterator iterator = mergedRegions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            sheet.addMergedRegion(region);
        }
    }

    private static void shiftUncoupledCellsUp(RowCollection rowCollection) {
        Row row = rowCollection.getParentRow();
        if (row.getCells().size() > rowCollection.getCells().size()) {
            for (int i = 0; i < row.getCells().size(); ++i) {
                Cell cell = (Cell)row.getCells().get(i);
                if (rowCollection.containsCell(cell)) continue;
                Util.shiftColumnUp(cell, row.getHssfRow().getRowNum() + rowCollection.getCollectionProperty().getCollection().size(), rowCollection.getCollectionProperty().getCollection().size() - 1);
            }
        }
    }

    private static void shiftColumnUp(Cell cell, int startRow, int shiftNumber) {
        int i;
        Region region;
        int i2;
        HSSFSheet sheet = cell.getRow().getSheet().getHssfSheet();
        short cellNum = cell.getHssfCell().getCellNum();
        ArrayList<Region> hssfMergedRegions = new ArrayList<Region>();
        for (i2 = startRow; i2 <= sheet.getLastRowNum(); ++i2) {
            region = Util.getMergedRegion(sheet, i2, cellNum);
            if (region == null || !Util.isNewMergedRegion(region, hssfMergedRegions)) continue;
            hssfMergedRegions.add(region);
        }
        for (i2 = startRow; i2 <= sheet.getLastRowNum(); ++i2) {
            if (sheet.getRow(i2).getCell(cellNum) == null) continue;
            HSSFCell destCell = sheet.getRow(i2 - shiftNumber).getCell(cellNum);
            if (destCell == null) {
                destCell = sheet.getRow(i2 - shiftNumber).createCell(cellNum);
            }
            Util.moveCell(sheet.getRow(i2).getCell(cellNum), destCell);
        }
        Iterator iterator = hssfMergedRegions.iterator();
        while (iterator.hasNext()) {
            Util.removeMergedRegion(sheet, (Region)iterator.next());
        }
        iterator = hssfMergedRegions.iterator();
        while (iterator.hasNext()) {
            region = (Region)iterator.next();
            Region newRegion = new Region(region.getRowFrom() - shiftNumber, region.getColumnFrom(), region.getRowTo() - shiftNumber, region.getColumnTo());
            sheet.addMergedRegion(newRegion);
        }
        for (i = sheet.getLastRowNum(); sheet.getRow(i).getCell(cellNum) == null && i >= startRow; --i) {
        }
        for (int j = 0; j < shiftNumber && i >= startRow; ++j, --i) {
            if (sheet.getRow(i).getCell(cellNum) == null) continue;
            sheet.getRow(i).removeCell(sheet.getRow(i).getCell(cellNum));
        }
    }

    private static void moveCell(HSSFCell srcCell, HSSFCell destCell) {
        destCell.setCellStyle(srcCell.getCellStyle());
        switch (srcCell.getCellType()) {
            case 1: {
                destCell.setCellValue(srcCell.getStringCellValue());
                break;
            }
            case 0: {
                destCell.setCellValue(srcCell.getNumericCellValue());
                break;
            }
            case 3: {
                destCell.setCellType(3);
                break;
            }
            case 4: {
                destCell.setCellValue(srcCell.getBooleanCellValue());
                break;
            }
            case 5: {
                destCell.setCellErrorValue(srcCell.getErrorCellValue());
                break;
            }
            case 2: {
                break;
            }
        }
        srcCell.setCellType(3);
    }

    private static void duplicateStyle(RowCollection rowCollection, int rowToCopy, int startRow, int num) {
        HSSFSheet sheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        TreeSet<Region> mergedRegions = new TreeSet<Region>();
        HSSFRow srcRow = sheet.getRow(rowToCopy);
        for (int i = startRow; i < startRow + num; ++i) {
            HSSFRow destRow = sheet.getRow(i);
            if (destRow == null) {
                destRow = sheet.createRow(i);
            }
            destRow.setHeight(srcRow.getHeight());
            for (int j = 0; j < rowCollection.getCells().size(); ++j) {
                Region newMergedRegion;
                Cell cell = (Cell)rowCollection.getCells().get(j);
                HSSFCell hssfCell = cell.getHssfCell();
                if (hssfCell == null) continue;
                HSSFCell newCell = destRow.createCell(hssfCell.getCellNum());
                Util.copyCell(hssfCell, newCell, true);
                Region mergedRegion = Util.getMergedRegion(sheet, rowToCopy, hssfCell.getCellNum());
                if (mergedRegion == null || !Util.isNewMergedRegion(newMergedRegion = new Region(i, mergedRegion.getColumnFrom(), i + mergedRegion.getRowTo() - mergedRegion.getRowFrom(), mergedRegion.getColumnTo()), mergedRegions)) continue;
                mergedRegions.add(newMergedRegion);
                sheet.addMergedRegion(newMergedRegion);
            }
        }
    }

    public static void copyRow(HSSFSheet sheet, HSSFRow oldRow, HSSFRow newRow) {
        TreeSet<Region> mergedRegions = new TreeSet<Region>();
        newRow.setHeight(oldRow.getHeight());
        for (short j = oldRow.getFirstCellNum(); j <= oldRow.getLastCellNum(); j = (short)(j + 1)) {
            Region newMergedRegion;
            HSSFCell oldCell = oldRow.getCell(j);
            HSSFCell newCell = newRow.getCell(j);
            if (oldCell == null) continue;
            if (newCell == null) {
                newCell = newRow.createCell(j);
            }
            Util.copyCell(oldCell, newCell, true);
            Region mergedRegion = Util.getMergedRegion(sheet, oldRow.getRowNum(), oldCell.getCellNum());
            if (mergedRegion == null || !Util.isNewMergedRegion(newMergedRegion = new Region(newRow.getRowNum(), mergedRegion.getColumnFrom(), newRow.getRowNum() + mergedRegion.getRowTo() - mergedRegion.getRowFrom(), mergedRegion.getColumnTo()), mergedRegions)) continue;
            mergedRegions.add(newMergedRegion);
            sheet.addMergedRegion(newMergedRegion);
        }
    }

    public static void copyRow(HSSFSheet srcSheet, HSSFSheet destSheet, HSSFRow srcRow, HSSFRow destRow) {
        TreeSet<Region> mergedRegions = new TreeSet<Region>();
        destRow.setHeight(srcRow.getHeight());
        for (short j = srcRow.getFirstCellNum(); j <= srcRow.getLastCellNum(); j = (short)(j + 1)) {
            Region newMergedRegion;
            HSSFCell oldCell = srcRow.getCell(j);
            HSSFCell newCell = destRow.getCell(j);
            if (oldCell == null) continue;
            if (newCell == null) {
                newCell = destRow.createCell(j);
            }
            Util.copyCell(oldCell, newCell, true);
            Region mergedRegion = Util.getMergedRegion(srcSheet, srcRow.getRowNum(), oldCell.getCellNum());
            if (mergedRegion == null || !Util.isNewMergedRegion(newMergedRegion = new Region(destRow.getRowNum(), mergedRegion.getColumnFrom(), destRow.getRowNum() + mergedRegion.getRowTo() - mergedRegion.getRowFrom(), mergedRegion.getColumnTo()), mergedRegions)) continue;
            mergedRegions.add(newMergedRegion);
            destSheet.addMergedRegion(newMergedRegion);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void copySheets(HSSFSheet newSheet, HSSFSheet sheet) {
        short s;
        void var3_4;
        short maxColumnNum = 0;
        int n = sheet.getFirstRowNum();
        while (var3_4 <= sheet.getLastRowNum()) {
            HSSFRow srcRow = sheet.getRow((int)var3_4);
            HSSFRow destRow = newSheet.createRow((int)var3_4);
            if (srcRow != null) {
                Util.copyRow(sheet, newSheet, srcRow, destRow);
                if (srcRow.getLastCellNum() > maxColumnNum) {
                    maxColumnNum = srcRow.getLastCellNum();
                }
            }
            ++var3_4;
        }
        boolean bl = false;
        while (s <= maxColumnNum) {
            newSheet.setColumnWidth(s, sheet.getColumnWidth(s));
            s = (short)(s + true);
        }
    }

    public static void copyCell(HSSFCell oldCell, HSSFCell newCell, boolean copyStyle) {
        if (copyStyle) {
            newCell.setCellStyle(oldCell.getCellStyle());
        }
        newCell.setEncoding(oldCell.getEncoding());
        switch (oldCell.getCellType()) {
            case 1: {
                newCell.setCellValue(oldCell.getStringCellValue());
                break;
            }
            case 0: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case 3: {
                newCell.setCellType(3);
                break;
            }
            case 4: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case 5: {
                newCell.setCellErrorValue(oldCell.getErrorCellValue());
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public static Object getProperty(Object bean, String propertyName) {
        Object value = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getting property=" + propertyName + " for bean=" + bean.getClass().getName()));
            }
            value = PropertyUtils.getProperty((Object)bean, (String)propertyName);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)("Can't get property " + propertyName + " in the bean " + bean), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.warn((Object)("Can't get property " + propertyName + " in the bean " + bean), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)("Can't get property " + propertyName + " in the bean " + bean), (Throwable)e);
        }
        return value;
    }

    public static void writeToFile(String fileName, HSSFWorkbook workbook) {
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(fileName));
            workbook.write((OutputStream)os);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HSSFCellStyle duplicateStyle(HSSFWorkbook workbook, HSSFCellStyle style) {
        HSSFCellStyle newStyle = workbook.createCellStyle();
        newStyle.setAlignment(style.getAlignment());
        newStyle.setBorderBottom(style.getBorderBottom());
        newStyle.setBorderLeft(style.getBorderLeft());
        newStyle.setBorderRight(style.getBorderRight());
        newStyle.setBorderTop(style.getBorderTop());
        newStyle.setBottomBorderColor(style.getBottomBorderColor());
        newStyle.setDataFormat(style.getDataFormat());
        newStyle.setFillBackgroundColor(style.getFillBackgroundColor());
        newStyle.setFillForegroundColor(style.getFillForegroundColor());
        newStyle.setFillPattern(style.getFillPattern());
        newStyle.setFont(workbook.getFontAt(style.getFontIndex()));
        newStyle.setHidden(style.getHidden());
        newStyle.setIndention(style.getIndention());
        newStyle.setLeftBorderColor(style.getLeftBorderColor());
        newStyle.setLocked(style.getLocked());
        newStyle.setRightBorderColor(style.getRightBorderColor());
        newStyle.setTopBorderColor(style.getTopBorderColor());
        newStyle.setVerticalAlignment(style.getVerticalAlignment());
        newStyle.setWrapText(style.getWrapText());
        return newStyle;
    }

    public static String escapeAttributes(String tag) {
        if (tag == null) {
            return tag;
        }
        StringBuffer sb = new StringBuffer("");
        StringBuffer attrValue = new StringBuffer("");
        int expressionClosingSymbol = 125;
        int expressionStartSymbol = 123;
        boolean isAttrValue = false;
        int exprCount = 0;
        for (int i = 0; i < tag.length(); ++i) {
            if (!isAttrValue) {
                sb.append(tag.charAt(i));
                if (tag.charAt(i) != '\"') continue;
                isAttrValue = true;
                attrValue = new StringBuffer("");
                continue;
            }
            if (tag.charAt(i) == '\"') {
                if (exprCount != 0) {
                    attrValue.append(tag.charAt(i));
                    continue;
                }
                sb.append(Util.escapeXml(attrValue.toString()));
                sb.append(tag.charAt(i));
                isAttrValue = false;
                continue;
            }
            attrValue.append(tag.charAt(i));
            if (tag.charAt(i) == '}') {
                --exprCount;
                continue;
            }
            if (tag.charAt(i) != '{') continue;
            ++exprCount;
        }
        if (isAttrValue) {
            log.warn((Object)("Can't parse ambiguous quot in " + tag));
        }
        return sb.toString();
    }

    private static String escapeXml(String str) {
        if (str == null) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length() * 2);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            String entityName = Util.getEntityName(ch);
            if (entityName == null) {
                if (ch > '\u007f') {
                    buf.append("&#");
                    buf.append((int)ch);
                    buf.append(';');
                    continue;
                }
                buf.append(ch);
                continue;
            }
            buf.append('&');
            buf.append(entityName);
            buf.append(';');
        }
        return buf.toString();
    }

    private static String getEntityName(char ch) {
        return (String)xmlEntities.get(Integer.toString(ch));
    }

    public static void shiftCellsLeft(HSSFSheet sheet, int startRow, short startCol, int endRow, short endCol, short shiftNumber) {
        for (int i = startRow; i <= endRow; ++i) {
            HSSFRow row = sheet.getRow(i);
            if (row == null) continue;
            for (short j = startCol; j <= endCol; j = (short)(j + 1)) {
                HSSFCell destCell;
                HSSFCell cell = row.getCell(j);
                if (cell == null) {
                    cell = row.createCell(j);
                }
                if ((destCell = row.getCell((short)(j - shiftNumber))) == null) {
                    destCell = row.createCell((short)(j - shiftNumber));
                }
                Util.copyCell(cell, destCell, true);
                sheet.setColumnWidth(destCell.getCellNum(), sheet.getColumnWidth(cell.getCellNum()));
            }
        }
    }

    public static void shiftCellsRight(HSSFSheet sheet, int startRow, int endRow, short startCol, short shiftNumber) {
        for (int i = startRow; i <= endRow; ++i) {
            short lastCellNum;
            HSSFRow row = sheet.getRow(i);
            if (row == null) continue;
            for (short j = lastCellNum = row.getLastCellNum(); j >= startCol; j = (short)(j - 1)) {
                HSSFCell cell;
                HSSFCell destCell = row.getCell((short)(j + shiftNumber));
                if (destCell == null) {
                    destCell = row.createCell((short)(j + shiftNumber));
                }
                if ((cell = row.getCell(j)) == null) {
                    cell = row.createCell(j);
                }
                Util.copyCell(cell, destCell, true);
            }
        }
    }

    public static void updateCellValue(HSSFSheet sheet, int rowNum, short colNum, String cellValue) {
        HSSFRow hssfRow = sheet.getRow(rowNum);
        HSSFCell hssfCell = hssfRow.getCell(colNum);
        hssfCell.setCellValue(cellValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        for (int i = 0; i < ENTITY_ARRAY.length; ++i) {
            xmlEntities.put(ENTITY_ARRAY[i][1], ENTITY_ARRAY[i][0]);
        }
    }
}

