/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellReference;
import org.jxls.tag.Block;
import org.jxls.tag.Point;
import org.jxls.util.Util;

public class TagBodyHelper {
    protected final Log log = LogFactory.getLog(this.getClass());

    public static int duplicateDown(HSSFSheet sheet, Block block, int n) {
        if (n > 0) {
            sheet.shiftRows(block.getEndRowNum() + 1, sheet.getLastRowNum(), block.getNumberOfRows() * n, true, false);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < block.getNumberOfRows(); ++j) {
                    HSSFRow row = sheet.getRow(block.getStartRowNum() + j);
                    HSSFRow newRow = sheet.getRow(block.getEndRowNum() + block.getNumberOfRows() * i + 1 + j);
                    if (row == null) continue;
                    if (newRow == null) {
                        newRow = sheet.createRow(block.getEndRowNum() + block.getNumberOfRows() * i + 1 + j);
                    }
                    Util.copyRow(sheet, row, newRow);
                }
            }
            return block.getNumberOfRows() * n;
        }
        return 0;
    }

    public static int duplicateDown(HSSFSheet sheet, Block block, int n, Map formulaCellsToUpdate) {
        if (n > 0) {
            sheet.shiftRows(block.getEndRowNum() + 1, sheet.getLastRowNum(), block.getNumberOfRows() * n, true, false);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < block.getNumberOfRows(); ++j) {
                    HSSFRow row = sheet.getRow(block.getStartRowNum() + j);
                    HSSFRow newRow = sheet.getRow(block.getEndRowNum() + block.getNumberOfRows() * i + 1 + j);
                    if (row == null) continue;
                    if (newRow == null) {
                        newRow = sheet.createRow(block.getEndRowNum() + block.getNumberOfRows() * i + 1 + j);
                    }
                    Util.copyRow(sheet, row, newRow);
                }
                Iterator iterator = formulaCellsToUpdate.keySet().iterator();
                while (iterator.hasNext()) {
                    Point point = (Point)iterator.next();
                    int rowNumToUpdate = block.getEndRowNum() + block.getNumberOfRows() * i + 1 + point.getRow() - block.getStartRowNum();
                    short colNumToUpdate = point.getCol();
                    TagBodyHelper.updateFormula(sheet, block.getNumberOfRows() * (i + 1), rowNumToUpdate, colNumToUpdate, (List)formulaCellsToUpdate.get(point));
                }
            }
            return block.getNumberOfRows() * n;
        }
        return 0;
    }

    private static String updateFormula(HSSFSheet sheet, int shiftNumber, int rowNumToUpdate, int colNumToUpdate, List refCellsToUpdate) {
        HSSFRow hssfRow = sheet.getRow(rowNumToUpdate);
        HSSFCell hssfCell = hssfRow.getCell((short)colNumToUpdate);
        String rawFormula = hssfCell.getStringCellValue();
        for (int i = 0; i < refCellsToUpdate.size(); ++i) {
            String refCell = (String)refCellsToUpdate.get(i);
            String newRefCell = TagBodyHelper.getUpdatedRefCell(refCell, shiftNumber);
            rawFormula = rawFormula.replaceAll("(?<!\\!)" + refCell, newRefCell);
        }
        hssfCell.setCellValue(rawFormula);
        return rawFormula;
    }

    private static String getUpdatedRefCell(String refCell, int rowShiftNumber) {
        CellReference cellReference = new CellReference(refCell);
        int rowNum = cellReference.getRow();
        cellReference = new CellReference(rowNum += rowShiftNumber, (int)cellReference.getCol());
        return cellReference.toString();
    }

    public static int duplicateRight(HSSFSheet sheet, Block block, int n) {
        if (n > 0) {
            Util.shiftCellsRight(sheet, block.getStartRowNum(), block.getEndRowNum(), (short)(block.getEndCellNum() + 1), (short)(block.getNumberOfColumns() * n));
            for (int i = block.getStartRowNum(); i <= block.getEndRowNum(); ++i) {
                HSSFRow row = sheet.getRow(i);
                if (row == null) continue;
                for (int k = 0; k < n; ++k) {
                    for (short j = block.getStartCellNum(); j <= block.getEndCellNum(); j = (short)(j + 1)) {
                        short destCellNum = (short)(block.getEndCellNum() + k * block.getNumberOfColumns() + j - block.getStartCellNum() + 1);
                        HSSFCell destCell = row.getCell(destCellNum);
                        HSSFCell cell = row.getCell(j);
                        if (destCell == null) {
                            destCell = row.createCell(destCellNum);
                        }
                        Util.copyCell(cell, destCell, true);
                        sheet.setColumnWidth(destCellNum, sheet.getColumnWidth(j));
                    }
                }
            }
            return block.getNumberOfColumns() * n;
        }
        return 0;
    }

    public static void replaceProperty(HSSFSheet sheet, Block block, String oldProperty, String newProperty) {
        for (int i = block.getStartRowNum(); i <= block.getEndRowNum(); ++i) {
            HSSFRow row = sheet.getRow(i);
            TagBodyHelper.replacePropertyInRow(row, oldProperty, newProperty);
        }
    }

    private static void replacePropertyInRow(HSSFRow row, String oldProperty, String newProperty) {
        for (short j = row.getFirstCellNum(); j <= row.getLastCellNum(); j = (short)(j + 1)) {
            HSSFCell cell = row.getCell(j);
            TagBodyHelper.replacePropertyInCell(cell, oldProperty, newProperty);
        }
    }

    private static void replacePropertyInCell(HSSFCell cell, String oldProperty, String newProperty) {
        if (cell != null && cell.getCellType() == 1) {
            String cellValue = cell.getStringCellValue();
            String newValue = cellValue.replaceAll(oldProperty, newProperty);
            cell.setCellValue(newValue);
        }
    }

    public static void removeBorders(HSSFSheet sheet, Block block) {
        sheet.removeRow(sheet.getRow(block.getStartRowNum()));
        block.setStartRowNum(block.getStartRowNum() + 1);
        sheet.removeRow(sheet.getRow(block.getEndRowNum()));
        block.setEndRowNum(block.getEndRowNum() - 1);
        TagBodyHelper.shift(sheet, block, -1);
        if (block.getEndRowNum() + 2 < sheet.getLastRowNum()) {
            sheet.shiftRows(block.getEndRowNum() + 3, sheet.getLastRowNum(), -2, true, false);
        }
    }

    public static void removeLeftRightBorders(HSSFSheet sheet, Block block) {
        HSSFRow row = sheet.getRow(block.getStartRowNum());
        if (row != null) {
            Util.shiftCellsLeft(sheet, block.getStartRowNum(), (short)(block.getStartCellNum() + 1), block.getEndRowNum(), row.getLastCellNum(), (short)1);
            TagBodyHelper.clearCell(row.getCell(row.getLastCellNum()));
            row.removeCell(row.getCell(row.getLastCellNum()));
            Util.shiftCellsLeft(sheet, block.getStartRowNum(), block.getEndCellNum(), block.getEndRowNum(), row.getLastCellNum(), (short)1);
            HSSFCell cell = row.getCell(row.getLastCellNum());
            TagBodyHelper.clearCell(cell);
            row.removeCell(cell);
            block.setEndCellNum((short)(block.getEndCellNum() - 2));
        }
    }

    public static void shift(HSSFSheet sheet, Block block, int n) {
        sheet.shiftRows(block.getStartRowNum(), block.getEndRowNum(), n, true, false);
        block.setStartRowNum(block.getStartRowNum() + n);
        block.setEndRowNum(block.getEndRowNum() + n);
    }

    public static void removeRowCells(HSSFSheet sheet, HSSFRow row, short startCellNum, short endCellNum) {
        TagBodyHelper.clearRowCells(row, startCellNum, endCellNum);
        Util.shiftCellsLeft(sheet, row.getRowNum(), (short)(endCellNum + 1), row.getRowNum(), row.getLastCellNum(), (short)(endCellNum - startCellNum + 1));
        TagBodyHelper.clearRowCells(row, (short)(row.getLastCellNum() - (endCellNum - startCellNum)), row.getLastCellNum());
    }

    public static void removeBodyRows(HSSFSheet sheet, Block block) {
        for (int i = 0; i < block.getNumberOfRows(); ++i) {
            HSSFRow row = sheet.getRow(block.getStartRowNum() + i);
            TagBodyHelper.removeMergedRegions(sheet, row);
            sheet.removeRow(row);
        }
        sheet.shiftRows(block.getEndRowNum() + 1, sheet.getLastRowNum(), -block.getNumberOfRows(), true, false);
    }

    private static void removeMergedRegions(HSSFSheet sheet, HSSFRow row) {
        if (row != null) {
            int i = row.getRowNum();
            for (short j = row.getFirstCellNum(); j <= row.getLastCellNum(); j = (short)(j + 1)) {
                Util.removeMergedRegion(sheet, i, j);
            }
        }
    }

    static void clearRow(HSSFRow row) {
        if (row != null) {
            for (short i = row.getFirstCellNum(); i <= row.getLastCellNum(); i = (short)(i + 1)) {
                HSSFCell cell = row.getCell(i);
                TagBodyHelper.clearCell(cell);
            }
        }
    }

    static void clearRowCells(HSSFRow row, short startCell, short endCell) {
        if (row != null) {
            for (short i = startCell; i <= endCell; i = (short)(i + 1)) {
                HSSFCell cell = row.getCell(i);
                TagBodyHelper.clearCell(cell);
            }
        }
    }

    static void clearCell(HSSFCell cell) {
        if (cell != null) {
            cell.setCellValue("");
            cell.setCellType(3);
        }
    }

    public static void adjustFormulas(HSSFWorkbook hssfWorkbook, HSSFSheet hssfSheet, Block body) {
        for (int i = body.getStartRowNum(); i <= body.getEndRowNum(); ++i) {
            HSSFRow row = hssfSheet.getRow(i);
            TagBodyHelper.adjustFormulas(row);
        }
    }

    private static void adjustFormulas(HSSFRow row) {
        if (row != null) {
            for (short i = row.getFirstCellNum(); i <= row.getLastCellNum(); i = (short)(i + 1)) {
                HSSFCell cell = row.getCell(i);
                if (cell == null || cell.getCellType() != 1 || !cell.getStringCellValue().matches("\\$\\[.*?\\]")) continue;
                String cellValue = cell.getStringCellValue();
                String[] parts = cellValue.split("\\$\\[.*?\\]");
                String newCellValue = parts[0];
                newCellValue = newCellValue.replaceAll("#", Integer.toString(row.getRowNum() + 1));
                cell.setCellValue(newCellValue);
            }
        }
    }
}

